/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.ringojs.repository.AbstractResource;
import org.ringojs.repository.FileRepository;

public class FileResource
extends AbstractResource {
    File file;

    public FileResource(String path) throws IOException {
        this(new File(path), null);
    }

    public FileResource(File file) throws IOException {
        this(file, null);
    }

    protected FileResource(File file, FileRepository repository) throws IOException {
        file = file.getAbsoluteFile();
        repository = repository == null ? new FileRepository(file.getParentFile()) : repository;
        file = new File(repository.getPath(), file.getName());
        this.path = file.getPath();
        this.name = file.getName();
        this.file = file;
        this.repository = repository;
        int lastDot = this.name.lastIndexOf(".");
        this.baseName = lastDot == -1 ? this.name : this.name.substring(0, lastDot);
    }

    public InputStream getInputStream() throws IOException {
        return this.stripShebang(new FileInputStream(this.file));
    }

    public URL getUrl() throws MalformedURLException {
        return new URL("file:" + this.file.getAbsolutePath());
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public long getLength() {
        return this.file.length();
    }

    public boolean exists() {
        return this.file.isFile();
    }

    public int hashCode() {
        return 17 + this.path.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FileResource && this.path.equals(((FileResource)obj).path);
    }

    public String toString() {
        return this.getPath();
    }
}

