/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.repository;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.ringojs.repository.AbstractRepository;
import org.ringojs.repository.AbstractResource;
import org.ringojs.repository.FileResource;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRepository
extends AbstractRepository {
    protected final File directory;
    protected long lastModified = -1L;
    protected long lastChecksum = 0L;
    protected long lastChecksumTime = 0L;
    final long cacheTime = 1000L;

    public FileRepository(String path) throws IOException {
        this(new File(path), null);
    }

    public FileRepository(File dir) throws IOException {
        this(dir, null);
    }

    protected FileRepository(File dir, FileRepository parent) throws IOException {
        this.directory = dir.getCanonicalFile();
        this.parent = parent;
        this.name = dir.getName();
        this.path = this.directory.getPath();
        if (!this.path.endsWith(File.separator)) {
            this.path = this.path + File.separator;
        }
    }

    @Override
    public boolean exists() {
        return this.directory.isDirectory();
    }

    @Override
    public AbstractRepository createChildRepository(String name) throws IOException {
        File f = new File(this.directory, name);
        return new FileRepository(f, this);
    }

    @Override
    public AbstractRepository getParentRepository() {
        if (this.parent == null) {
            try {
                AbstractRepository repo;
                SoftReference ref = (SoftReference)this.repositories.get("..");
                AbstractRepository abstractRepository = repo = ref == null ? null : (AbstractRepository)ref.get();
                if (repo == null) {
                    repo = new FileRepository(this.directory.getParentFile());
                    repo.setAbsolute(true);
                    this.repositories.put("..", new SoftReference<AbstractRepository>(repo));
                }
                return repo;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.parent;
    }

    @Override
    public long lastModified() {
        return this.directory.lastModified();
    }

    @Override
    public synchronized long getChecksum() throws IOException {
        if (System.currentTimeMillis() > this.lastChecksumTime + 1000L) {
            long checksum = this.lastModified;
            for (Resource res : this.resources.values()) {
                checksum += res.lastModified();
            }
            this.lastChecksum = checksum;
            this.lastChecksumTime = System.currentTimeMillis();
        }
        return this.lastChecksum;
    }

    @Override
    protected Resource lookupResource(String name) throws IOException {
        AbstractResource res = (AbstractResource)this.resources.get(name);
        if (res == null) {
            res = new FileResource(new File(this.directory, name), this);
            this.resources.put(name, res);
        }
        return res;
    }

    @Override
    protected void getResources(List<Resource> list, boolean recursive) throws IOException {
        File[] dir;
        for (File file : dir = this.directory.listFiles()) {
            if (file.isFile()) {
                Resource resource = this.lookupResource(file.getName());
                list.add(resource);
                continue;
            }
            if (!recursive || !file.isDirectory()) continue;
            AbstractRepository repo = this.lookupRepository(file.getName());
            repo.getResources(list, true);
        }
    }

    @Override
    public Repository[] getRepositories() throws IOException {
        File[] dir = this.directory.listFiles();
        ArrayList<AbstractRepository> list = new ArrayList<AbstractRepository>(dir.length);
        for (File file : dir) {
            if (!file.isDirectory()) continue;
            list.add(this.lookupRepository(file.getName()));
        }
        return list.toArray(new Repository[list.size()]);
    }

    @Override
    public URL getUrl() throws MalformedURLException {
        return new URL("file:" + this.path);
    }

    public int hashCode() {
        return 17 + 37 * this.directory.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FileRepository && this.directory.equals(((FileRepository)obj).directory);
    }

    @Override
    public String toString() {
        return new StringBuffer("FileRepository[").append(this.path).append("]").toString();
    }
}

