/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.repository;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.ringojs.repository.AbstractRepository;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;

public abstract class AbstractResource
implements Resource {
    protected AbstractRepository repository;
    protected String path;
    protected String name;
    protected String baseName;
    private boolean stripShebang = false;
    private int lineNumber = 1;

    protected void setBaseNameFromName(String name) {
        int lastDot = name.lastIndexOf(".");
        this.baseName = lastDot == -1 ? name : name.substring(0, lastDot);
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Repository getParentRepository() {
        return this.repository;
    }

    public Repository getRootRepository() {
        return this.repository.getRootRepository();
    }

    protected InputStream stripShebang(InputStream stream) throws IOException {
        if (this.stripShebang) {
            stream = new BufferedInputStream(stream);
            stream.mark(2);
            if (stream.read() == 35 && stream.read() == 33) {
                int c = stream.read();
                while (c != -1 && c != 10) {
                    if (c == 13) {
                        stream.mark(1);
                        if (stream.read() == 10) break;
                        stream.reset();
                        break;
                    }
                    c = stream.read();
                }
                this.lineNumber = 2;
            } else {
                stream.reset();
            }
        }
        return stream;
    }

    public Reader getReader(String encoding) throws IOException {
        return new InputStreamReader(this.getInputStream(), encoding);
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent(String encoding) throws IOException {
        InputStream in = this.getInputStream();
        try {
            int r;
            byte[] buf = new byte[1024];
            int read = 0;
            while ((r = in.read(buf, read, buf.length - read)) != -1) {
                if ((read += r) != buf.length) continue;
                byte[] b = new byte[buf.length * 2];
                System.arraycopy(buf, 0, b, 0, buf.length);
                buf = b;
            }
            String string = encoding == null ? new String(buf, 0, read) : new String(buf, 0, read, encoding);
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getContent() throws IOException {
        return this.getContent("utf-8");
    }

    public String getRelativePath() {
        if (this.repository == null) {
            return this.name;
        }
        return this.repository.getRelativePath() + this.name;
    }

    public String getModuleName() {
        if (this.repository == null) {
            return this.baseName;
        }
        return this.repository.getRelativePath() + this.baseName;
    }

    public long getChecksum() {
        return this.lastModified();
    }

    public boolean getStripShebang() {
        return this.stripShebang;
    }

    public void setStripShebang(boolean stripShebang) {
        this.stripShebang = stripShebang;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setAbsolute(boolean absolute) {
        this.repository.setAbsolute(absolute);
    }

    public boolean isAbsolute() {
        return this.repository.isAbsolute();
    }
}

