/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.repository;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ringojs.repository.AbstractResource;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;
import org.ringojs.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepository
implements Repository {
    AbstractRepository parent;
    Map<String, SoftReference<AbstractRepository>> repositories = Collections.synchronizedMap(new HashMap());
    Map<String, AbstractResource> resources = Collections.synchronizedMap(new HashMap());
    String path;
    String name;
    private boolean isAbsolute = false;

    protected abstract Resource lookupResource(String var1) throws IOException;

    protected abstract AbstractRepository createChildRepository(String var1) throws IOException;

    protected abstract void getResources(List<Resource> var1, boolean var2) throws IOException;

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setRoot() {
        this.parent = null;
    }

    @Override
    public void setAbsolute(boolean absolute) {
        this.isAbsolute = absolute;
    }

    @Override
    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    @Override
    public String getRelativePath() {
        if (this.isAbsolute) {
            return this.path;
        }
        if (this.parent == null) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        this.getRelativePath(b);
        return b.toString();
    }

    private void getRelativePath(StringBuffer buffer) {
        if (this.isAbsolute) {
            buffer.append(this.path);
        } else if (this.parent != null) {
            this.parent.getRelativePath(buffer);
            buffer.append(this.name).append('/');
        }
    }

    @Override
    public String getModuleName() {
        return this.getRelativePath();
    }

    protected String[] resolve(String path, boolean absolute) {
        String[] elements = StringUtils.split(path, SEPARATOR);
        LinkedList<String> list = new LinkedList<String>();
        if (absolute) {
            list.addAll(Arrays.asList(StringUtils.split(this.path, SEPARATOR)));
        }
        for (String e : elements) {
            if ("..".equals(e)) {
                String last;
                String string = last = list.isEmpty() ? null : (String)list.getLast();
                if (last == null || "..".equals(last)) {
                    list.add(e);
                    continue;
                }
                if (this.isAbsolute && list.size() <= 1) continue;
                list.removeLast();
                continue;
            }
            if (".".equals(e) || "".equals(e)) continue;
            list.add(e);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public synchronized Resource getResource(String subpath) throws IOException {
        String[] list = this.resolve(subpath, false);
        AbstractRepository repo = this;
        if (list.length == 0) {
            repo = this.getParentRepository();
            return repo == null ? null : repo.getResource(this.name);
        }
        String last = list[list.length - 1];
        for (String e : list) {
            if (repo == null || e == last) break;
            repo = repo.lookupRepository(e);
        }
        return repo == null ? null : repo.lookupResource(last);
    }

    @Override
    public AbstractRepository getChildRepository(String subpath) throws IOException {
        String[] list = this.resolve(subpath, false);
        AbstractRepository repo = this;
        for (String e : list) {
            if (repo == null) {
                return null;
            }
            repo = repo.lookupRepository(e);
        }
        return repo;
    }

    protected AbstractRepository lookupRepository(String name) throws IOException {
        AbstractRepository repo;
        if (".".equals(name) || "".equals(name)) {
            return this;
        }
        if ("..".equals(name)) {
            return this.getParentRepository();
        }
        SoftReference<AbstractRepository> ref = this.repositories.get(name);
        AbstractRepository abstractRepository = repo = ref == null ? null : ref.get();
        if (repo == null) {
            repo = this.createChildRepository(name);
            this.repositories.put(name, new SoftReference<AbstractRepository>(repo));
        }
        return repo;
    }

    @Override
    public AbstractRepository getParentRepository() {
        return this.parent;
    }

    @Override
    public Repository getRootRepository() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootRepository();
    }

    @Override
    public Resource[] getResources() throws IOException {
        return this.getResources(false);
    }

    @Override
    public Resource[] getResources(boolean recursive) throws IOException {
        ArrayList<Resource> list = new ArrayList<Resource>();
        this.getResources(list, recursive);
        return list.toArray(new Resource[list.size()]);
    }

    @Override
    public Resource[] getResources(String resourcePath, boolean recursive) throws IOException {
        AbstractRepository repository = this.getChildRepository(resourcePath);
        if (repository == null || !repository.exists()) {
            return new Resource[0];
        }
        return repository.getResources(recursive);
    }

    public String toString() {
        return this.getPath();
    }

    private int findSeparator(String path, int start) {
        int max = path.length();
        int numberOfSeparators = SEPARATOR.length();
        int found = -1;
        block0: for (int i = 0; i < numberOfSeparators; ++i) {
            char c = SEPARATOR.charAt(i);
            for (int j = start; j < max; ++j) {
                if (path.charAt(j) != c) continue;
                found = max = j;
                continue block0;
            }
        }
        return found;
    }
}

