/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.jsgi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.RhinoException;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.engine.RingoConfig;
import org.ringojs.engine.RingoWorker;
import org.ringojs.engine.ScriptError;
import org.ringojs.jsgi.JsgiRequest;
import org.ringojs.repository.AbstractRepository;
import org.ringojs.repository.FileRepository;
import org.ringojs.repository.WebappRepository;
import org.ringojs.tools.RingoRunner;
import org.ringojs.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsgiServlet
extends HttpServlet {
    String module;
    Object function;
    RhinoEngine engine;
    JsgiRequest requestProto;

    public JsgiServlet() {
    }

    public JsgiServlet(RhinoEngine engine) throws ServletException {
        this(engine, null);
    }

    public JsgiServlet(RhinoEngine engine, Callable callable) throws ServletException {
        this.engine = engine;
        this.function = callable;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.function == null) {
            this.module = this.getStringParameter(config, "app-module", "main");
            this.function = this.getStringParameter(config, "app-name", "app");
        }
        if (this.engine == null) {
            String ringoHome = this.getStringParameter(config, "ringo-home", "/WEB-INF");
            String modulePath = this.getStringParameter(config, "module-path", "WEB-INF/app");
            String bootScripts = this.getStringParameter(config, "bootscript", null);
            int optlevel = this.getIntParameter(config, "optlevel", 0);
            boolean debug = this.getBooleanParameter(config, "debug", false);
            boolean production = this.getBooleanParameter(config, "production", false);
            boolean verbose = this.getBooleanParameter(config, "verbose", false);
            boolean legacyMode = this.getBooleanParameter(config, "legacy-mode", false);
            ServletContext context = config.getServletContext();
            WebappRepository base = new WebappRepository(context, "/");
            AbstractRepository home = new WebappRepository(context, ringoHome);
            try {
                if (!home.exists()) {
                    home = new FileRepository(ringoHome);
                    System.err.println("Resource \"" + ringoHome + "\" not found, reverting to file repository " + home);
                }
                String[] paths = StringUtils.split(modulePath, ",");
                String[] systemPaths = new String[]{"modules", "packages"};
                RingoConfig ringoConfig = new RingoConfig(home, base, paths, systemPaths);
                ringoConfig.setDebug(debug);
                ringoConfig.setVerbose(verbose);
                ringoConfig.setParentProtoProperties(legacyMode);
                ringoConfig.setStrictVars(!legacyMode && !production);
                ringoConfig.setReloading(!production);
                ringoConfig.setOptLevel(optlevel);
                if (bootScripts != null) {
                    ringoConfig.setBootstrapScripts(Arrays.asList(StringUtils.split(bootScripts, ",")));
                }
                this.engine = new RhinoEngine(ringoConfig, null);
            }
            catch (Exception x) {
                throw new ServletException((Throwable)x);
            }
        }
        this.requestProto = new JsgiRequest(this.engine.getScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JsgiRequest req = new JsgiRequest(request, response, this.requestProto, this.engine.getScope(), this);
        RingoWorker worker = this.engine.getWorker();
        try {
            worker.invoke("ringo/jsgi/connector", "handleRequest", new Object[]{this.module, this.function, req});
        }
        catch (Exception x) {
            List<ScriptError> errors = worker.getErrors();
            boolean verbose = this.engine.getConfig().isVerbose();
            try {
                this.renderError(x, response, errors);
                RingoRunner.reportError(x, System.err, errors, verbose);
            }
            catch (Exception failed) {
                RingoRunner.reportError(x, System.err, errors, false);
                throw new ServletException((Throwable)x);
            }
        }
        finally {
            worker.release();
        }
    }

    protected void renderError(Throwable t, HttpServletResponse response, List<ScriptError> errors) throws IOException {
        int r;
        response.reset();
        InputStream stream = JsgiServlet.class.getResourceAsStream("error.html");
        byte[] buffer = new byte[1024];
        int read = 0;
        while ((r = stream.read(buffer, read, buffer.length - read)) != -1) {
            if ((read += r) != buffer.length) continue;
            byte[] b = new byte[buffer.length * 2];
            System.arraycopy(buffer, 0, b, 0, buffer.length);
            buffer = b;
        }
        String template = new String(buffer, 0, read);
        String title = t instanceof RhinoException ? ((RhinoException)t).details() : t.getMessage();
        StringBuilder body = new StringBuilder();
        if (t instanceof RhinoException) {
            RhinoException rx = (RhinoException)t;
            if (errors != null && !errors.isEmpty()) {
                for (ScriptError error : errors) {
                    body.append(error.toHtml());
                }
            } else {
                body.append("<p><b>").append(rx.sourceName()).append("</b>, line <b>").append(rx.lineNumber()).append("</b></p>");
            }
            body.append("<h3>Script Stack</h3><pre>").append(rx.getScriptStackTrace()).append("</pre>");
        }
        template = template.replaceAll("<% title %>", title);
        template = template.replaceAll("<% body %>", body.toString());
        response.setStatus(500);
        response.setContentType("text/html");
        response.getWriter().write(template);
    }

    protected String getStringParameter(ServletConfig config, String name, String defaultValue) {
        String value = config.getInitParameter(name);
        return value == null ? defaultValue : value;
    }

    protected int getIntParameter(ServletConfig config, String name, int defaultValue) {
        String value = config.getInitParameter(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfx) {
                System.err.println("Invalid value for parameter \"" + name + "\": " + value);
            }
        }
        return defaultValue;
    }

    protected boolean getBooleanParameter(ServletConfig config, String name, boolean defaultValue) {
        String value = config.getInitParameter(name);
        if (value != null) {
            if ("true".equals(value) || "1".equals(value) || "on".equals(value)) {
                return true;
            }
            if ("false".equals(value) || "0".equals(value) || "off".equals(value)) {
                return false;
            }
            System.err.println("Invalid value for parameter \"" + name + "\": " + value);
        }
        return defaultValue;
    }
}

