/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.jsgi;

import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.ringojs.jsgi.JsgiServlet;

public class JsgiRequest
extends ScriptableObject {
    Scriptable jsgiObject;
    HttpServletRequest request;
    HttpServletResponse response;
    int readonly = 5;
    Object httpVersion;

    public JsgiRequest(Scriptable scope) {
        this.setParentScope(scope);
        this.setPrototype(JsgiRequest.getObjectPrototype((Scriptable)scope));
        try {
            this.defineProperty("host", null, JsgiRequest.getMethod("getServerName"), null, this.readonly);
            this.defineProperty("port", null, JsgiRequest.getMethod("getServerPort"), null, this.readonly);
            this.defineProperty("queryString", null, JsgiRequest.getMethod("getQueryString"), null, this.readonly);
            this.defineProperty("version", null, JsgiRequest.getMethod("getHttpVersion"), null, this.readonly);
            this.defineProperty("remoteAddress", null, JsgiRequest.getMethod("getRemoteHost"), null, this.readonly);
            this.defineProperty("scheme", null, JsgiRequest.getMethod("getUrlScheme"), null, this.readonly);
            this.defineProperty("async", null, JsgiRequest.getMethod("isAsyncSupported"), null, this.readonly);
        }
        catch (NoSuchMethodException nsm) {
            throw new RuntimeException(nsm);
        }
        this.defineProperty("constructor", JsgiRequest.getProperty((Scriptable)scope, (String)"Object"), 2);
        Scriptable jsgi = this.jsgiObject = this.newObject(scope);
        Scriptable version = this.newArray(scope, new Object[]{0, 3});
        JsgiRequest.defineProperty((Scriptable)jsgi, (String)"version", (Object)version, (int)this.readonly);
        JsgiRequest.defineProperty((Scriptable)jsgi, (String)"multithread", (Object)Boolean.TRUE, (int)this.readonly);
        JsgiRequest.defineProperty((Scriptable)jsgi, (String)"multiprocess", (Object)Boolean.FALSE, (int)this.readonly);
        JsgiRequest.defineProperty((Scriptable)jsgi, (String)"runOnce", (Object)Boolean.FALSE, (int)this.readonly);
        JsgiRequest.defineProperty((Scriptable)jsgi, (String)"cgi", (Object)Boolean.FALSE, (int)this.readonly);
    }

    public JsgiRequest(HttpServletRequest request, HttpServletResponse response, JsgiRequest prototype, Scriptable scope, JsgiServlet servlet) {
        this.request = request;
        this.response = response;
        this.setPrototype((Scriptable)prototype);
        this.setParentScope(scope);
        Scriptable jsgi = this.newObject(scope);
        jsgi.setPrototype(prototype.jsgiObject);
        JsgiRequest.defineProperty((Scriptable)this, (String)"jsgi", (Object)jsgi, (int)4);
        Scriptable headers = this.newObject(scope);
        JsgiRequest.defineProperty((Scriptable)this, (String)"headers", (Object)headers, (int)4);
        StringBuilder sb = new StringBuilder(160);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            sb.setLength(0);
            boolean multipleHeaders = false;
            String name = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(name);
            while (headerValues.hasMoreElements()) {
                if (multipleHeaders) {
                    sb.append(",");
                }
                sb.append((String)headerValues.nextElement());
                multipleHeaders = true;
            }
            name = name.toLowerCase();
            headers.put(name, headers, (Object)sb.toString());
        }
        this.put("scriptName", (Scriptable)this, JsgiRequest.checkString(request.getContextPath() + request.getServletPath()));
        String pathInfo = request.getPathInfo();
        String uri = request.getRequestURI();
        this.put("pathInfo", (Scriptable)this, "/".equals(pathInfo) && !uri.endsWith("/") ? "" : JsgiRequest.checkString(pathInfo));
        this.put("method", (Scriptable)this, JsgiRequest.checkString(request.getMethod()));
        Scriptable env = this.newObject(scope);
        JsgiRequest.defineProperty((Scriptable)this, (String)"env", (Object)env, (int)4);
        JsgiRequest.defineProperty((Scriptable)env, (String)"servlet", (Object)new NativeJavaObject(scope, (Object)servlet, null), (int)4);
        JsgiRequest.defineProperty((Scriptable)env, (String)"servletRequest", (Object)new NativeJavaObject(scope, (Object)request, null), (int)4);
        JsgiRequest.defineProperty((Scriptable)env, (String)"servletResponse", (Object)new NativeJavaObject(scope, (Object)response, null), (int)4);
        this.defineProperty("constructor", scope.get("Object", scope), 2);
    }

    public String getServerName() {
        return JsgiRequest.checkString(this.request.getServerName());
    }

    public String getServerPort() {
        return JsgiRequest.checkString(Integer.toString(this.request.getServerPort()));
    }

    public String getQueryString() {
        return JsgiRequest.checkString(this.request.getQueryString());
    }

    public Object getHttpVersion() {
        if (this.httpVersion == null) {
            Scriptable scope = this.getParentScope();
            String protocol = this.request.getProtocol();
            if (protocol != null) {
                int major = protocol.indexOf(47);
                int minor = protocol.indexOf(46);
                if (major > -1 && minor > major) {
                    major = Integer.parseInt(protocol.substring(major + 1, minor));
                    minor = Integer.parseInt(protocol.substring(minor + 1));
                    this.httpVersion = this.newArray(scope, new Object[]{major, minor});
                }
            }
            if (this.httpVersion == null) {
                this.newArray(scope, new Object[0]);
            }
        }
        return this.httpVersion;
    }

    public String getRemoteHost() {
        return JsgiRequest.checkString(this.request.getRemoteHost());
    }

    public String getUrlScheme() {
        return this.request.isSecure() ? "https" : "http";
    }

    public boolean isAsyncSupported() {
        return this.request.isAsyncSupported();
    }

    private static Method getMethod(String name) throws NoSuchMethodException {
        return JsgiRequest.class.getDeclaredMethod(name, new Class[0]);
    }

    private static String checkString(String str) {
        return str == null ? "" : str;
    }

    private Scriptable newObject(Scriptable scope) {
        NativeObject result = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
        return result;
    }

    private Scriptable newArray(Scriptable scope, Object[] elements) {
        NativeArray result = new NativeArray(elements);
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Array);
        return result;
    }

    public String getClassName() {
        return "JsgiRequest";
    }
}

