/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import org.ringojs.util.StringUtils;

public class ScriptError {
    public final String message;
    public final String sourceName;
    public final String lineSource;
    public final int lineNumber;
    public final int offset;

    ScriptError(String message, String sourceName, int lineNumber, String lineSource, int offset) {
        this.message = message;
        this.sourceName = sourceName == null ? "[unknown source]" : sourceName;
        this.lineSource = lineSource;
        this.lineNumber = lineNumber;
        this.offset = offset;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuilder b = new StringBuilder(this.sourceName).append(", line ").append(this.lineNumber).append(": ").append(this.message).append(lineSeparator).append(this.lineSource).append(lineSeparator);
        for (int i = 0; i < this.offset - 1; ++i) {
            b.append(' ');
        }
        b.append('^');
        return b.toString();
    }

    public String toHtml() {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuilder b = new StringBuilder("<p>").append(this.sourceName).append(", line ").append(this.lineNumber).append(": <b>").append(StringUtils.escapeHtml(this.message)).append("</b></p>").append(lineSeparator).append("<pre>");
        int srcLength = this.lineSource.length();
        int errorStart = Math.max(0, this.offset - 2);
        int errorEnd = Math.min(srcLength, this.offset);
        b.append(StringUtils.escapeHtml(this.lineSource.substring(0, errorStart))).append("<span style='border-bottom: 3px solid red;'>").append(StringUtils.escapeHtml(this.lineSource.substring(errorStart, errorEnd))).append("</span>").append(StringUtils.escapeHtml(this.lineSource.substring(errorEnd))).append(lineSeparator).append("</pre>");
        return b.toString();
    }
}

