/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;
import org.ringojs.engine.ReloadableScript;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.engine.ScriptError;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RingoWorker {
    private EventLoop eventloop;
    private final RhinoEngine engine;
    private final ReentrantLock runlock = new ReentrantLock();
    private ReloadableScript currentScript;
    private List<ScriptError> errors;
    private Function errorListener;
    private Map<Resource, Scriptable> modules;
    private Map<Resource, Scriptable> checkedModules;
    private boolean reload;
    private static AtomicInteger workerId = new AtomicInteger(1);
    private final int id;

    public RingoWorker(RhinoEngine engine) {
        this.engine = engine;
        this.modules = new HashMap<Resource, Scriptable>();
        this.reload = engine.getConfig().isReloading();
        this.checkedModules = this.reload ? new HashMap() : this.modules;
        this.id = workerId.getAndIncrement();
    }

    public String toString() {
        return "ringo-worker-" + this.id;
    }

    public Object invoke(Object module, Object function, Object ... args) throws NoSuchMethodException, IOException {
        Scriptable scope = this.engine.getScope();
        Context cx = this.engine.getContextFactory().enterContext(null);
        this.errors = new LinkedList<ScriptError>();
        RingoWorker previous = this.acquireWorker();
        if (this.reload) {
            this.checkedModules.clear();
        }
        try {
            Scriptable scriptable;
            if (!(module instanceof CharSequence) && !(module instanceof Scriptable)) {
                throw new IllegalArgumentException("module argument must be a Scriptable or String object");
            }
            if (module instanceof Scriptable) {
                scriptable = (Scriptable)module;
            } else {
                String moduleId = ScriptRuntime.toString((Object)module);
                scriptable = this.loadModule(cx, moduleId, null);
            }
            if (!(function instanceof Function)) {
                Object fun = ScriptableObject.getProperty((Scriptable)scriptable, (String)function.toString());
                if (!(fun instanceof Function)) {
                    throw new NoSuchMethodException("Function " + function + " not defined");
                }
                function = fun;
            }
            this.engine.initArguments(args);
            Object retval = ((Function)function).call(cx, scope, scriptable, args);
            Object object = retval instanceof Wrapper ? ((Wrapper)retval).unwrap() : retval;
            return object;
        }
        catch (RhinoException rx) {
            if (this.errorListener != null) {
                Object error = rx instanceof JavaScriptException ? ((JavaScriptException)rx).getValue() : ScriptRuntime.wrapException((Throwable)rx, (Scriptable)scope, (Context)cx);
                this.errorListener.call(cx, scope, scope, new Object[]{error});
                Object var9_12 = null;
                return var9_12;
            }
            throw rx;
        }
        finally {
            this.releaseWorker(previous);
            Context.exit();
        }
    }

    public Future<Object> submit(final Object module, final Object function, final Object ... args) {
        this.engine.enterAsyncTask();
        return this.getEventLoop().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Object object = RingoWorker.this.invoke(module, function, args);
                    return object;
                }
                finally {
                    RingoWorker.this.engine.exitAsyncTask();
                }
            }
        });
    }

    public ScheduledFuture<Object> schedule(long delay, final Object module, final Object function, final Object ... args) {
        this.engine.enterAsyncTask();
        return this.getEventLoop().schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Object object = RingoWorker.this.invoke(module, function, args);
                    return object;
                }
                finally {
                    RingoWorker.this.engine.exitAsyncTask();
                }
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> scheduleInterval(long interval, final Object module, final Object function, final Object ... args) {
        this.engine.enterAsyncTask();
        return this.getEventLoop().scheduleWithFixedDelay(new Runnable(){

            public void run() {
                try {
                    RingoWorker.this.invoke(module, function, args);
                }
                catch (Exception x) {
                    throw new RuntimeException(x);
                }
            }
        }, interval, interval, TimeUnit.MILLISECONDS);
    }

    public Future<Object> loadModuleInWorkerThread(final String module) {
        this.engine.enterAsyncTask();
        return this.getEventLoop().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (RingoWorker.this.reload) {
                    RingoWorker.this.checkedModules.clear();
                }
                Context cx = RingoWorker.this.engine.getContextFactory().enterContext(null);
                try {
                    Scriptable scriptable = RingoWorker.this.loadModule(cx, module, null);
                    return scriptable;
                }
                finally {
                    Context.exit();
                    RingoWorker.this.engine.exitAsyncTask();
                }
            }
        });
    }

    public void cancel(Future<?> future) {
        if (future.cancel(false)) {
            this.engine.exitAsyncTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scriptable loadModule(Context cx, String moduleName, Scriptable loadingScope) throws IOException {
        Repository local = this.engine.getParentRepository(loadingScope);
        ReloadableScript script = this.engine.getScript(moduleName, local);
        if (this.checkedModules.containsKey(script.resource)) {
            return this.checkedModules.get(script.resource);
        }
        Scriptable module = this.modules.get(script.resource);
        ReloadableScript parent = this.currentScript;
        RingoWorker previous = this.acquireWorker();
        try {
            this.currentScript = script;
            module = script.load(this.engine.getScope(), cx, module, this);
            this.modules.put(script.resource, module);
        }
        finally {
            this.currentScript = parent;
            this.releaseWorker(previous);
            if (parent != null) {
                parent.addDependency(script);
            }
        }
        return module;
    }

    protected void registerModule(Resource resource, Scriptable module) {
        this.checkedModules.put(resource, module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateScript(Context cx, ReloadableScript script, Scriptable scope) throws IOException {
        Object result;
        ReloadableScript parent = this.currentScript;
        this.errors = new LinkedList<ScriptError>();
        RingoWorker previous = this.acquireWorker();
        try {
            this.currentScript = script;
            result = script.evaluate(scope, cx, this);
            this.modules.put(script.resource, scope);
        }
        finally {
            this.currentScript = parent;
            this.releaseWorker(previous);
            if (parent != null) {
                parent.addDependency(script);
            }
        }
        return result;
    }

    public boolean isReloading() {
        return this.reload;
    }

    public void setReloading(boolean reload) {
        if (reload != this.reload) {
            this.checkedModules = reload ? new HashMap() : this.modules;
        }
        this.reload = reload;
    }

    public Function getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(Function errorListener) {
        this.errorListener = errorListener;
    }

    public RhinoEngine getEngine() {
        return this.engine;
    }

    public List<ScriptError> getErrors() {
        return this.errors;
    }

    public long countScheduledTasks() {
        EventLoop eventloop = this.eventloop;
        return eventloop == null ? 0L : (long)eventloop.getQueue().size();
    }

    public boolean isActive() {
        Delayed task;
        if (this.runlock.isLocked()) {
            return true;
        }
        EventLoop eventloop = this.eventloop;
        return eventloop != null && (task = (Delayed)eventloop.getQueue().peek()) != null && task.getDelay(TimeUnit.MILLISECONDS) < 1L;
    }

    public synchronized void shutdown() {
        EventLoop eventloop = this.eventloop;
        if (eventloop != null) {
            eventloop.shutdownNow();
            this.eventloop = null;
        }
    }

    public void release() {
        this.engine.returnWorker(this);
    }

    public void releaseWhenDone() {
        if (this.isActive()) {
            this.getEventLoop().submit(new Runnable(){

                public void run() {
                    RingoWorker.this.release();
                }
            });
        } else {
            this.release();
        }
    }

    private RingoWorker acquireWorker() {
        this.runlock.lock();
        return this.engine.setCurrentWorker(this);
    }

    private void releaseWorker(RingoWorker previous) {
        this.engine.setCurrentWorker(previous);
        this.runlock.unlock();
    }

    private synchronized EventLoop getEventLoop() {
        if (this.eventloop == null) {
            this.eventloop = new EventLoop(this.id);
        }
        return this.eventloop;
    }

    static class EventLoop
    extends ScheduledThreadPoolExecutor {
        EventLoop(final int id) {
            super(1, new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "ringo-worker-" + id);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.setKeepAliveTime(60000L, TimeUnit.MILLISECONDS);
            this.allowCoreThreadTimeOut(true);
        }
    }
}

