/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.tools.shell.Environment;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.QuitAction;
import org.ringojs.engine.Require;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;
import org.ringojs.repository.Trackable;
import org.ringojs.security.RingoSecurityManager;
import org.ringojs.util.ScriptUtils;

public class RingoGlobal
extends Global {
    private final RhinoEngine engine;
    private static final SecurityManager securityManager = System.getSecurityManager();
    private static ExecutorService threadPool;
    private static AtomicInteger ids;

    public RingoGlobal(Context cx, RhinoEngine engine, boolean sealed) {
        this.engine = engine;
        this.init(cx, engine, sealed);
    }

    public void init(Context cx, RhinoEngine engine, boolean sealed) {
        this.initStandardObjects(cx, sealed);
        this.initQuitAction(new QuitAction(){

            public void quit(Context cx, int exitCode) {
                System.exit(exitCode);
            }
        });
        String[] names = new String[]{"gc", "load", "print", "quit", "seal", "sync"};
        this.defineFunctionProperties(names, Global.class, 2);
        names = new String[]{"defineClass", "getResource", "getRepository", "addToClasspath", "privileged", "spawn"};
        this.defineFunctionProperties(names, RingoGlobal.class, 2);
        this.defineProperty("require", (Object)new Require(engine, this), 2);
        this.defineProperty("arguments", cx.newArray((Scriptable)this, engine.getArguments()), 2);
        Environment.defineClass((ScriptableObject)this);
        Environment environment = new Environment((ScriptableObject)this);
        this.defineProperty("environment", environment, 2);
    }

    public RhinoEngine getEngine() {
        return this.engine;
    }

    public static void defineClass(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object arg;
        ScriptUtils.checkArguments(args, 1, 1);
        Object object = arg = args[0] instanceof Wrapper ? ((Wrapper)args[0]).unwrap() : args[0];
        if (!(arg instanceof Class)) {
            throw Context.reportRuntimeError((String)"defineClass() requires a class argument");
        }
        RhinoEngine engine = ((RingoGlobal)funObj.getParentScope()).engine;
        engine.defineHostClass((Class)arg);
    }

    public static Object getResource(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length != 1 || !(args[0] instanceof String)) {
            throw Context.reportRuntimeError((String)"getResource() requires a string argument");
        }
        RhinoEngine engine = ((RingoGlobal)funObj.getParentScope()).engine;
        try {
            Resource res = engine.findResource((String)args[0], null, engine.getParentRepository(thisObj));
            return cx.getWrapFactory().wrapAsJavaObject(cx, engine.getScope(), (Object)res, null);
        }
        catch (IOException iox) {
            throw Context.reportRuntimeError((String)("Cannot find resource " + args[0] + "'"));
        }
    }

    public static Object getRepository(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length != 1 || !(args[0] instanceof String)) {
            throw Context.reportRuntimeError((String)"getRepository() requires a string argument");
        }
        RhinoEngine engine = ((RingoGlobal)funObj.getParentScope()).engine;
        try {
            Repository repo = engine.findRepository((String)args[0], engine.getParentRepository(thisObj));
            return cx.getWrapFactory().wrapAsJavaObject(cx, engine.getScope(), (Object)repo, null);
        }
        catch (IOException iox) {
            throw Context.reportRuntimeError((String)("Cannot find repository " + args[0] + "'"));
        }
    }

    public static Object addToClasspath(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (securityManager != null) {
            securityManager.checkPermission(RingoSecurityManager.GET_CLASSLOADER);
        }
        if (args.length != 1) {
            throw Context.reportRuntimeError((String)"addToClasspath() requires one argument");
        }
        try {
            Trackable path;
            Object arg;
            RhinoEngine engine = ((RingoGlobal)funObj.getParentScope()).engine;
            Object object = arg = args[0] instanceof Wrapper ? ((Wrapper)args[0]).unwrap() : args[0];
            if (arg instanceof String) {
                path = engine.resolve((String)arg, engine.getParentRepository(thisObj));
            } else if (arg instanceof Trackable) {
                path = (Trackable)arg;
            } else {
                throw Context.reportRuntimeError((String)"addToClasspath() requires a path argument");
            }
            if (!path.exists()) {
                throw Context.reportRuntimeError((String)("addToClasspath(): Cannot find " + path));
            }
            engine.addToClasspath(path);
            return Boolean.TRUE;
        }
        catch (IOException iox) {
            throw new WrappedException((Throwable)iox);
        }
    }

    public static Object privileged(final Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length != 1 || !(args[0] instanceof Function)) {
            throw Context.reportRuntimeError((String)"privileged() requires a function argument");
        }
        final Scriptable scope = RingoGlobal.getTopLevelScope((Scriptable)thisObj);
        Scriptable s = cx.newObject(scope);
        s.put("run", s, args[0]);
        final Object[] jargs = new Object[]{new NativeJavaClass(scope, PrivilegedAction.class), s};
        PrivilegedAction action = AccessController.doPrivileged(new PrivilegedAction<PrivilegedAction>(){

            @Override
            public PrivilegedAction run() {
                return (PrivilegedAction)((Wrapper)cx.newObject(scope, "JavaAdapter", jargs)).unwrap();
            }
        });
        return cx.getWrapFactory().wrap(cx, scope, AccessController.doPrivileged(action), null);
    }

    public static Object spawn(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (securityManager != null) {
            securityManager.checkPermission(RingoSecurityManager.SPAWN_THREAD);
        }
        if (args.length < 1 || !(args[0] instanceof Function)) {
            throw Context.reportRuntimeError((String)"spawn() requires a function argument");
        }
        final Scriptable scope = funObj.getParentScope();
        final ContextFactory cxfactory = cx.getFactory();
        final Function function = (Function)args[0];
        final Object[] fnArgs = args.length > 1 && args[1] instanceof Scriptable ? cx.getElements((Scriptable)args[1]) : ScriptRuntime.emptyArgs;
        return RingoGlobal.getThreadPool().submit(new Callable<Object>(){

            @Override
            public Object call() {
                return cxfactory.call(new ContextAction(){

                    public Object run(Context cx) {
                        return function.call(cx, scope, scope, fnArgs);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExecutorService getThreadPool() {
        if (threadPool != null) {
            return threadPool;
        }
        Class<Global> clazz = Global.class;
        synchronized (Global.class) {
            if (threadPool == null) {
                threadPool = Executors.newCachedThreadPool(new ThreadFactory(){

                    public Thread newThread(Runnable runnable) {
                        Thread thread = new Thread(runnable, "ringo-spawn-" + ids.incrementAndGet());
                        thread.setDaemon(true);
                        return thread;
                    }
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return threadPool;
        }
    }

    static {
        ids = new AtomicInteger();
    }
}

