/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.PolicySecurityController;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.engine.RingoConfig;

public class RingoContextFactory
extends ContextFactory {
    RhinoEngine engine;
    int languageVersion = 180;
    boolean strictMode = false;
    boolean strictVars = true;
    boolean warningAsError = false;
    boolean parentProtoProperties = true;
    int optimizationLevel = 0;
    boolean generatingDebug = true;
    ClassShutter classShutter;
    static int instructionLimit = 0xFFFFFFF;

    public RingoContextFactory(RhinoEngine engine, RingoConfig config) {
        this.engine = engine;
        this.optimizationLevel = config.getOptLevel();
        this.languageVersion = config.getLanguageVersion();
        this.parentProtoProperties = config.hasParentProtoProperties();
        this.classShutter = config.getClassShutter();
        this.strictVars = config.getStrictVars();
    }

    protected boolean hasFeature(Context cx, int featureIndex) {
        switch (featureIndex) {
            case 8: {
                return this.strictVars;
            }
            case 9: 
            case 11: {
                return this.strictMode;
            }
            case 3: {
                return true;
            }
            case 12: {
                return this.warningAsError;
            }
            case 5: {
                return this.parentProtoProperties;
            }
            case 10: {
                return true;
            }
        }
        return super.hasFeature(cx, featureIndex);
    }

    protected void onContextCreated(Context cx) {
        super.onContextCreated(cx);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(RingoContextFactory.this.engine.getClassLoader());
                return null;
            }
        });
        cx.setApplicationClassLoader((ClassLoader)this.engine.getClassLoader());
        cx.setWrapFactory(this.engine.getWrapFactory());
        cx.setLanguageVersion(this.languageVersion);
        cx.setOptimizationLevel(this.optimizationLevel);
        if (this.classShutter != null) {
            cx.setClassShutter(this.classShutter);
        }
        if (this.engine.isPolicyEnabled()) {
            cx.setInstructionObserverThreshold(instructionLimit);
            cx.setSecurityController((SecurityController)new PolicySecurityController());
        }
        cx.setErrorReporter((ErrorReporter)new ToolErrorReporter(true));
        cx.setGeneratingDebug(this.generatingDebug);
    }

    protected void onContextReleased(Context cx) {
        super.onContextReleased(cx);
    }

    protected void observeInstructionCount(Context cx, int instructionCount) {
        if (instructionCount > instructionLimit) {
            throw new Error("Maximum instruction count exceeded");
        }
    }

    public void setStrictMode(boolean flag) {
        this.checkNotSealed();
        this.strictMode = flag;
    }

    public void setParentProtoProperties(boolean flag) {
        this.checkNotSealed();
        this.parentProtoProperties = flag;
    }

    public void setWarningAsError(boolean flag) {
        this.checkNotSealed();
        this.warningAsError = flag;
    }

    public void setLanguageVersion(int version) {
        Context.checkLanguageVersion((int)version);
        this.checkNotSealed();
        this.languageVersion = version;
    }

    public void setOptimizationLevel(int optimizationLevel) {
        Context.checkOptimizationLevel((int)optimizationLevel);
        this.checkNotSealed();
        this.optimizationLevel = optimizationLevel;
    }

    public void setGeneratingDebug(boolean generatingDebug) {
        this.generatingDebug = generatingDebug;
    }
}

