/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;
import org.ringojs.engine.ModuleLoader;
import org.ringojs.engine.NotFound;
import org.ringojs.engine.RingoWrapFactory;
import org.ringojs.repository.FileRepository;
import org.ringojs.repository.FileResource;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;
import org.ringojs.repository.ZipRepository;
import org.ringojs.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingoConfig {
    private Repository ringoHome;
    private Repository appHome;
    private List<Repository> repositories = new ArrayList<Repository>();
    private Resource mainResource;
    private String[] arguments;
    private int optimizationLevel = 0;
    private boolean strictVars = true;
    private boolean debug = false;
    private boolean verbose = false;
    private int languageVersion = 180;
    private boolean parentProtoProperties = false;
    private Class<Scriptable>[] hostClasses = null;
    private ClassShutter classShutter = null;
    private WrapFactory wrapFactory = null;
    private List<String> bootstrapScripts;
    private boolean sealed = false;
    private boolean policyEnabled = false;
    private boolean reloading = true;
    private String charset = "UTF-8";

    public RingoConfig(Repository ringoHome) throws IOException {
        this(ringoHome, null, null, new String[]{"modules", "packages"});
    }

    public RingoConfig(Repository ringoHome, String[] userModules, String[] systemModules) throws IOException {
        this(ringoHome, null, userModules, systemModules);
    }

    public RingoConfig(Repository ringoHome, Repository appHome, String[] userModules, String[] systemModules) throws IOException {
        String path;
        String parentProto;
        String langVersion;
        String optLevel;
        this.ringoHome = ringoHome;
        ringoHome.setAbsolute(true);
        if (appHome != null) {
            this.appHome = appHome;
            appHome.setAbsolute(true);
        }
        if ((optLevel = System.getProperty("rhino.optlevel")) != null) {
            this.optimizationLevel = Integer.parseInt(optLevel);
        }
        if ((langVersion = System.getProperty("rhino.langversion")) != null) {
            this.languageVersion = Integer.parseInt(langVersion);
        }
        if ((parentProto = System.getProperty("rhino.parentproto")) != null) {
            boolean bl = this.parentProtoProperties = Integer.parseInt(parentProto) != 0;
        }
        if (userModules != null) {
            if (userModules.length > 0) {
                for (String pathElem : userModules) {
                    path = pathElem.trim();
                    this.addModuleRepository(this.resolveRepository(path, false));
                }
            } else {
                File candidatePath = new File(System.getProperty("user.dir"), "packages");
                if (candidatePath.isDirectory()) {
                    this.addModuleRepository(this.resolveRepository(candidatePath.toString(), false));
                }
            }
        }
        if (systemModules != null) {
            for (String pathElem : systemModules) {
                path = pathElem.trim();
                this.addModuleRepository(this.resolveRepository(path, true));
            }
        }
        RingoConfig.getLogger().config("Ringo repository list: " + this.repositories);
    }

    public void addModuleRepository(Repository repository) {
        if (repository != null) {
            repository.setRoot();
            this.repositories.add(repository);
        }
    }

    public Repository resolveRepository(String path, boolean system) throws IOException {
        Repository repo;
        File file = new File(path);
        if (!file.isAbsolute()) {
            Repository parent = system ? this.ringoHome : this.appHome;
            repo = this.resolveRepository(path, parent);
            if (repo != null) {
                return repo;
            }
            file = file.getAbsoluteFile();
        }
        repo = file.isFile() && StringUtils.isZipOrJarFile(path) ? new ZipRepository(file) : new FileRepository(file);
        RingoConfig.getLogger().fine("Resolved module path " + path + ": " + repo);
        return repo;
    }

    private Repository resolveRepository(String path, Repository parent) throws IOException {
        Repository repository;
        if (parent != null && (repository = parent.getChildRepository(path)) != null && repository.exists()) {
            repository.setRoot();
            return repository;
        }
        ClassLoader loader = RingoConfig.class.getClassLoader();
        repository = RingoConfig.repositoryFromClasspath(path, loader);
        if (repository != null && repository.exists()) {
            repository.setRoot();
            RingoConfig.getLogger().info("Loading " + path + " from classpath: " + repository);
            return repository;
        }
        return null;
    }

    public void setMainScript(String scriptName) throws IOException {
        if (scriptName != null) {
            Resource script;
            String scriptPath;
            int zip;
            File file = new File(scriptName);
            if (file.isFile() && StringUtils.isZipOrJarFile(scriptName)) {
                ZipRepository zipRepo = new ZipRepository(new File(scriptName));
                this.mainResource = zipRepo.getResource("main.js");
                if (this.mainResource.exists()) {
                    this.repositories.add(0, zipRepo);
                    return;
                }
            }
            if ((zip = scriptName.toLowerCase().indexOf(".zip/")) > -1) {
                String zipFile = scriptName.substring(0, zip + 4);
                scriptPath = scriptName.substring(zip + 5);
                ZipRepository zipRepo = new ZipRepository(new File(zipFile));
                this.mainResource = zipRepo.getResource(scriptPath);
                if (this.mainResource.exists()) {
                    this.repositories.add(0, zipRepo);
                    return;
                }
            }
            if ((script = new FileResource(file)).exists()) {
                scriptPath = script.getPath();
                for (Repository repo : this.repositories) {
                    if (!(repo instanceof FileRepository) || scriptPath.indexOf(repo.getPath()) != 0) continue;
                    this.mainResource = repo.getResource(scriptPath.substring(repo.getPath().length()));
                    return;
                }
                script.setAbsolute(true);
                this.mainResource = script;
            } else {
                script = this.getResource(scriptName);
                if (!script.exists()) {
                    script = this.getResource(scriptName + ".js");
                }
                if (!script.exists()) {
                    throw new FileNotFoundException("Can't find file " + scriptName);
                }
                this.mainResource = script;
            }
        }
    }

    public Resource getMainResource() {
        return this.mainResource;
    }

    public Repository getRingoHome() {
        return this.ringoHome;
    }

    public List<Repository> getRepositories() {
        return this.repositories;
    }

    public String getMainModule() {
        return this.mainResource == null ? null : this.mainResource.getModuleName();
    }

    public void setHostClasses(Class<Scriptable>[] classes) {
        this.hostClasses = classes;
    }

    public Class<Scriptable>[] getHostClasses() {
        return this.hostClasses;
    }

    public int getOptLevel() {
        return this.debug ? -1 : this.optimizationLevel;
    }

    public void setOptLevel(int optlevel) {
        this.optimizationLevel = optlevel;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        System.setProperty("ringo.verbose", String.valueOf(verbose));
    }

    public boolean getStrictVars() {
        return this.strictVars;
    }

    public void setStrictVars(boolean strictVars) {
        this.strictVars = strictVars;
    }

    public int getLanguageVersion() {
        return this.languageVersion;
    }

    public boolean hasParentProtoProperties() {
        return this.parentProtoProperties;
    }

    public void setParentProtoProperties(boolean flag) {
        this.parentProtoProperties = flag;
    }

    public Resource getResource(String path) throws IOException {
        return this.getResource(path, null);
    }

    public Resource getResource(String path, ModuleLoader[] loaders) throws IOException {
        Resource res;
        for (Repository repo : this.repositories) {
            if (loaders != null) {
                assert (loaders.length > 0 && loaders[0] != null);
                for (ModuleLoader loader : loaders) {
                    res = repo.getResource(path + loader.getExtension());
                    if (res == null || !res.exists()) continue;
                    return res;
                }
                continue;
            }
            res = repo.getResource(path);
            if (res == null || !res.exists()) continue;
            return res;
        }
        if (loaders == null) {
            res = RingoConfig.resourceFromClasspath(path, null);
            if (res != null && res.exists()) {
                return res;
            }
        } else {
            for (ModuleLoader loader : loaders) {
                String p = path + loader.getExtension();
                res = RingoConfig.resourceFromClasspath(p, null);
                if (res == null || !res.exists()) continue;
                return res;
            }
        }
        return new NotFound(path);
    }

    public Repository getRepository(String path) throws IOException {
        Repository repo;
        for (Repository parent : this.repositories) {
            repo = parent.getChildRepository(path);
            if (repo == null || !repo.exists()) continue;
            return repo;
        }
        repo = RingoConfig.repositoryFromClasspath(path, null);
        if (repo != null && repo.exists()) {
            return repo;
        }
        return new NotFound(path);
    }

    public List<Resource> getResources(String path, boolean recursive) throws IOException {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Repository repo : this.repositories) {
            Collections.addAll(list, repo.getResources(path, recursive));
        }
        return list;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public ClassShutter getClassShutter() {
        return this.classShutter;
    }

    public void setClassShutter(ClassShutter classShutter) {
        this.classShutter = classShutter;
    }

    public WrapFactory getWrapFactory() {
        if (this.wrapFactory == null) {
            this.wrapFactory = new RingoWrapFactory();
        }
        return this.wrapFactory;
    }

    public void setWrapFactory(WrapFactory wrapFactory) {
        this.wrapFactory = wrapFactory;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public void setSealed(boolean sealed) {
        this.sealed = sealed;
    }

    public boolean isReloading() {
        return this.reloading;
    }

    public void setReloading(boolean reloading) {
        this.reloading = reloading;
    }

    public boolean isPolicyEnabled() {
        return this.policyEnabled;
    }

    public void setPolicyEnabled(boolean hasPolicy) {
        this.policyEnabled = hasPolicy;
    }

    public List<String> getBootstrapScripts() {
        return this.bootstrapScripts;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public void setBootstrapScripts(List<String> bootstrapScripts) {
        this.bootstrapScripts = bootstrapScripts;
    }

    private static Logger getLogger() {
        return Logger.getLogger(RingoConfig.class.getName());
    }

    private static Repository toZipRepository(URL url) throws IOException {
        String nested = url.getPath();
        int excl = nested.indexOf("!");
        if (excl > -1) {
            nested = nested.substring(0, excl);
            try {
                url = new URL(nested);
            }
            catch (MalformedURLException e) {
                url = new URL("file://" + nested);
            }
            if ("file".equals(url.getProtocol())) {
                String enc = Charset.defaultCharset().name();
                return new ZipRepository(URLDecoder.decode(url.getPath(), enc));
            }
        }
        return null;
    }

    private static Resource resourceFromClasspath(String path, ClassLoader loader) throws IOException {
        String canonicalPath = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        URL url = RingoConfig.urlFromClasspath(canonicalPath, loader);
        if (url != null) {
            String proto = url.getProtocol();
            if ("jar".equals(proto) || "zip".equals(proto) || "wsjar".equals(proto)) {
                Repository repo = RingoConfig.toZipRepository(url);
                return repo.getResource(path);
            }
            if ("file".equals(proto)) {
                String enc = Charset.defaultCharset().name();
                return new FileResource(URLDecoder.decode(url.getPath(), enc));
            }
        }
        return null;
    }

    private static Repository repositoryFromClasspath(String path, ClassLoader loader) throws IOException {
        String canonicalPath = path.endsWith("/") ? path : path + "/";
        URL url = RingoConfig.urlFromClasspath(canonicalPath, loader);
        if (url != null) {
            String proto = url.getProtocol();
            if ("jar".equals(proto) || "zip".equals(proto) || "wsjar".equals(proto)) {
                Repository repo = RingoConfig.toZipRepository(url);
                return repo.getChildRepository(path);
            }
            if ("file".equals(proto)) {
                String enc = Charset.defaultCharset().name();
                return new FileRepository(URLDecoder.decode(url.getPath(), enc));
            }
        }
        return null;
    }

    private static URL urlFromClasspath(String path, ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = RingoConfig.class.getClassLoader();
        }
        if (loader == null) {
            return null;
        }
        return loader.getResource(path);
    }
}

