/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.json.JsonParser;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.ringojs.engine.AppClassLoader;
import org.ringojs.engine.Callback;
import org.ringojs.engine.ClassModuleLoader;
import org.ringojs.engine.JsModuleLoader;
import org.ringojs.engine.JsonModuleLoader;
import org.ringojs.engine.ModuleLoader;
import org.ringojs.engine.ModuleObject;
import org.ringojs.engine.ModuleScope;
import org.ringojs.engine.ReloadableScript;
import org.ringojs.engine.RingoConfig;
import org.ringojs.engine.RingoContextFactory;
import org.ringojs.engine.RingoGlobal;
import org.ringojs.engine.RingoWorker;
import org.ringojs.engine.ScriptError;
import org.ringojs.engine.ScriptedModuleLoader;
import org.ringojs.engine.Singleton;
import org.ringojs.repository.FileRepository;
import org.ringojs.repository.FileResource;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;
import org.ringojs.repository.StringResource;
import org.ringojs.repository.Trackable;
import org.ringojs.tools.RingoDebugger;
import org.ringojs.tools.launcher.RingoClassLoader;
import org.ringojs.util.StringUtils;
import org.ringojs.wrappers.ScriptableList;
import org.ringojs.wrappers.ScriptableMap;
import org.ringojs.wrappers.ScriptableWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoEngine
implements ScopeProvider {
    private RingoConfig config;
    private List<Repository> repositories;
    private RingoGlobal globalScope;
    private List<String> commandLineArgs;
    private Map<Trackable, ReloadableScript> compiledScripts;
    private Map<Trackable, ReloadableScript> interpretedScripts;
    private final Map<Singleton, Singleton> singletons;
    private AppClassLoader loader = new AppClassLoader();
    private WrapFactory wrapFactory;
    private Set<Class> hostClasses;
    private ModuleLoader[] loaders;
    private List<Callback> shutdownHooks;
    private RingoContextFactory contextFactory = null;
    private ModuleScope mainScope = null;
    private final RingoWorker mainWorker;
    private final Deque<RingoWorker> workers;
    private final ThreadLocal<RingoWorker> currentWorker;
    private final AsyncTaskCounter asyncCounter = new AsyncTaskCounter();
    private static Logger log = Logger.getLogger(RhinoEngine.class.getName());
    public static final List<Integer> VERSION = Collections.unmodifiableList(Arrays.asList(0, 12, 0));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RhinoEngine(RingoConfig config, Map<String, Object> globals) throws Exception {
        this.config = config;
        this.workers = new LinkedBlockingDeque<RingoWorker>();
        this.currentWorker = new ThreadLocal();
        this.mainWorker = new RingoWorker(this);
        this.compiledScripts = new ConcurrentHashMap<Trackable, ReloadableScript>();
        this.interpretedScripts = new ConcurrentHashMap<Trackable, ReloadableScript>();
        this.singletons = new HashMap<Singleton, Singleton>();
        this.contextFactory = new RingoContextFactory(this, config);
        this.repositories = config.getRepositories();
        this.wrapFactory = config.getWrapFactory();
        this.loaders = new ModuleLoader[]{new JsModuleLoader(), new JsonModuleLoader(), new ClassModuleLoader()};
        RingoDebugger debugger = null;
        if (config.getDebug()) {
            debugger = new RingoDebugger(config);
            debugger.setScopeProvider(this);
            debugger.attachTo(this.contextFactory);
            debugger.setBreakOnExceptions(true);
        }
        Context cx = this.contextFactory.enterContext();
        try {
            boolean sealed = config.isSealed();
            this.globalScope = new RingoGlobal(cx, this, sealed);
            Class<Scriptable>[] classes = config.getHostClasses();
            if (classes != null) {
                for (Class<Scriptable> clazz : classes) {
                    this.defineHostClass(clazz);
                }
            }
            ScriptableList.init((Scriptable)this.globalScope);
            ScriptableMap.init((Scriptable)this.globalScope);
            ScriptableObject.defineClass((Scriptable)this.globalScope, ScriptableWrapper.class);
            ScriptableObject.defineClass((Scriptable)this.globalScope, ModuleObject.class);
            if (globals != null) {
                for (Map.Entry entry : globals.entrySet()) {
                    ScriptableObject.defineProperty((Scriptable)this.globalScope, (String)((String)entry.getKey()), entry.getValue(), (int)2);
                }
            }
            this.mainWorker.evaluateScript(cx, this.getScript("globals"), (Scriptable)this.globalScope);
            this.evaluateBootstrapScripts(cx);
            if (sealed) {
                this.globalScope.sealObject();
            }
            if (debugger != null) {
                debugger.setBreak();
            }
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        RhinoEngine.this.shutdown();
                    }
                });
            }
            catch (AccessControlException e) {
                log.log(Level.WARNING, "Could not register shutdown hook due to security exception", e);
            }
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineHostClass(Class<Scriptable> clazz) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        if (this.hostClasses != null && this.hostClasses.contains(clazz)) {
            return;
        }
        RhinoEngine rhinoEngine = this;
        synchronized (rhinoEngine) {
            if (this.hostClasses == null) {
                this.hostClasses = new HashSet<Class>();
            }
            this.hostClasses.add(clazz);
            ScriptableObject.defineClass((Scriptable)this.globalScope, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runScript(Object scriptResource, String ... scriptArgs) throws IOException, JavaScriptException {
        Resource resource;
        if (scriptResource instanceof Resource) {
            resource = (Resource)scriptResource;
        } else if (scriptResource instanceof String) {
            resource = this.findResource((String)scriptResource, null, null);
        } else {
            throw new IOException("Unsupported script resource: " + scriptResource);
        }
        if (!resource.exists()) {
            throw new FileNotFoundException(scriptResource.toString());
        }
        Context cx = this.contextFactory.enterContext();
        try {
            Map<Trackable, ReloadableScript> scripts = this.getScriptCache(cx);
            this.commandLineArgs = Arrays.asList(scriptArgs);
            ReloadableScript script = new ReloadableScript(resource, this);
            scripts.put(resource, script);
            this.mainScope = new ModuleScope(resource.getModuleName(), resource, (Scriptable)this.globalScope, this.mainWorker);
            Object retval = this.mainWorker.evaluateScript(cx, script, (Scriptable)this.mainScope);
            this.mainScope.updateExports();
            Object object = retval instanceof Wrapper ? ((Wrapper)retval).unwrap() : retval;
            return object;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateExpression(String expr) throws IOException, JavaScriptException {
        Context cx = this.contextFactory.enterContext();
        cx.setOptimizationLevel(-1);
        try {
            Repository repository = this.repositories.get(0);
            Object parentScope = this.mainScope != null ? this.mainScope : this.globalScope;
            ModuleScope scope = new ModuleScope("<expr>", repository, (Scriptable)parentScope, this.mainWorker);
            StringResource res = new StringResource("<expr>", expr, 1);
            ReloadableScript script = new ReloadableScript(res, this);
            Object retval = this.mainWorker.evaluateScript(cx, script, (Scriptable)scope);
            Object object = retval instanceof Wrapper ? ((Wrapper)retval).unwrap() : retval;
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public Object invoke(Object module, String method, Object ... args) throws IOException, NoSuchMethodException, ExecutionException, InterruptedException {
        return this.mainWorker.invoke(module, method, args);
    }

    protected RingoWorker setCurrentWorker(RingoWorker worker) {
        RingoWorker previousWorker = this.currentWorker.get();
        this.currentWorker.set(worker);
        return previousWorker;
    }

    public RingoWorker getCurrentWorker(Scriptable obj) {
        RingoWorker worker = this.currentWorker.get();
        for (Scriptable scriptable = obj; scriptable != null; scriptable = scriptable.getParentScope()) {
            if (!(scriptable instanceof ModuleScope)) continue;
            RingoWorker scopeWorker = ((ModuleScope)scriptable).getWorker();
            if (worker == null) {
                worker = scopeWorker;
                break;
            }
            if (worker == scopeWorker) break;
            throw new IllegalStateException("Current thread worker differs from scope worker");
        }
        if (worker == null) {
            throw new IllegalStateException("No worker associated with current thread or scope");
        }
        return worker;
    }

    public RingoWorker getMainWorker() {
        return this.mainWorker;
    }

    public RingoWorker getWorker() {
        RingoWorker worker = this.workers.pollFirst();
        if (worker == null) {
            worker = new RingoWorker(this);
        }
        return worker;
    }

    void returnWorker(RingoWorker worker) {
        if (!this.workers.offerFirst(worker)) {
            worker.shutdown();
        }
    }

    synchronized void shutdown() {
        List<Callback> hooks = this.shutdownHooks;
        if (hooks != null) {
            for (Callback callback : hooks) {
                try {
                    Object result = callback.invoke(new Object[0]);
                    if (callback.sync || !(result instanceof Future)) continue;
                    ((Future)result).get();
                }
                catch (Exception x) {
                    log.log(Level.WARNING, "Error in shutdown hook", x);
                }
            }
            this.shutdownHooks = null;
        }
    }

    public synchronized void addShutdownHook(Scriptable callback, boolean sync) {
        List<Callback> hooks = this.shutdownHooks;
        if (hooks == null) {
            hooks = this.shutdownHooks = new ArrayList<Callback>();
        }
        hooks.add(new Callback(callback, this, sync));
    }

    public List<ScriptError> getMainErrors() {
        return this.mainWorker.getErrors();
    }

    public Scriptable getShellScope(RingoWorker worker) throws IOException {
        FileRepository repository = new FileRepository("");
        repository.setAbsolute(true);
        Object protoScope = this.mainScope != null ? this.mainScope : this.globalScope;
        return new ModuleScope("<shell>", repository, (Scriptable)protoScope, worker);
    }

    public Scriptable getScope() {
        return this.globalScope;
    }

    protected void initArguments(Object[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = RhinoEngine.wrapArgument(args[i], (Scriptable)this.globalScope);
            }
        }
    }

    public static Object wrapArgument(Object value, Scriptable scope) {
        if (value instanceof ScriptableObject) {
            ScriptableObject scriptable = (ScriptableObject)value;
            if (scriptable.getPrototype() == null) {
                scriptable.setPrototype(ScriptableObject.getClassPrototype((Scriptable)scope, (String)scriptable.getClassName()));
            }
            if (scriptable.getParentScope() == null) {
                scriptable.setParentScope(scope);
            }
            return scriptable;
        }
        return Context.javaToJS((Object)value, (Scriptable)scope);
    }

    public int getOptimizationLevel() {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            return cx.getOptimizationLevel();
        }
        return 0;
    }

    public void setOptimizationLevel(int level) {
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.getOptimizationLevel() != level) {
            cx.setOptimizationLevel(level);
        }
    }

    public ReloadableScript getScript(String moduleName) throws JavaScriptException, IOException {
        return this.getScript(moduleName, null);
    }

    public ReloadableScript getScript(String moduleName, Repository localPath) throws JavaScriptException, IOException {
        ReloadableScript script;
        Context cx;
        Map<Trackable, ReloadableScript> scripts;
        Resource source = this.findResource(moduleName, this.loaders, localPath);
        if (!source.exists() && !(source = this.loadPackage(moduleName, localPath)).exists()) {
            source = this.findResource(moduleName, null, localPath);
        }
        if ((scripts = this.getScriptCache(cx = Context.getCurrentContext())).containsKey(source)) {
            script = scripts.get(source);
        } else {
            script = new ReloadableScript(source, this);
            if (source.exists()) {
                scripts.put(source, script);
            }
        }
        return script;
    }

    protected Resource loadPackage(String moduleName, Repository localPath) throws IOException {
        int slash = 0;
        do {
            Resource res;
            String moduleId;
            String remainingName;
            String packageName;
            if ((slash = moduleName.indexOf(47, slash + 1)) == -1) {
                packageName = moduleName;
                remainingName = null;
            } else {
                packageName = moduleName.substring(0, slash);
                if (".".equals(packageName) || "..".equals(packageName)) continue;
                remainingName = moduleName.substring(slash + 1);
            }
            Resource json = this.findResource(packageName + "/package.json", null, localPath);
            if (json == null || !json.exists()) continue;
            Scriptable obj = this.parseJsonResource(json);
            Repository parent = json.getParentRepository();
            Object jars = ScriptableObject.getProperty((Scriptable)obj, (String)"jars");
            if (jars != null && jars instanceof Scriptable && ScriptRuntime.isArrayObject((Object)jars)) {
                Object[] jarsToLoad;
                Object[] objectArray = jarsToLoad = ScriptRuntime.getArrayElements((Scriptable)((Scriptable)jars));
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object jar = objectArray[i];
                    Resource jarResource = parent.getResource(jar.toString());
                    if (!jarResource.exists()) {
                        log.warning("Skipping non-existing JAR resource in package.json descriptor for " + packageName + ": " + jar.toString() + " - " + jarResource.getUrl());
                        continue;
                    }
                    log.config("Adding JAR resource from " + packageName + " package.json descriptor to classpath: " + jarResource.getUrl());
                    this.loader.addURL(jarResource.getUrl());
                }
            }
            if (remainingName == null) {
                moduleId = this.getStringProperty(obj, "main", null);
                if (moduleId != null && (res = parent.getResource(moduleId)) != null && res.exists()) {
                    return res;
                }
            } else {
                String lib = "lib";
                Object dirs = ScriptableObject.getProperty((Scriptable)obj, (String)"directories");
                if (dirs instanceof Scriptable) {
                    lib = this.getStringProperty((Scriptable)dirs, "lib", "lib");
                }
                moduleId = lib + "/" + remainingName;
            }
            if (moduleId == null) continue;
            for (ModuleLoader loader : this.loaders) {
                res = parent.getResource(moduleId + loader.getExtension());
                if (res == null || !res.exists()) continue;
                return res;
            }
            if (remainingName == null || (res = parent.getResource(moduleId)) == null || !res.exists()) continue;
            return res;
        } while (slash != -1);
        return this.findResource(moduleName + "/index", this.loaders, localPath);
    }

    private Scriptable parseJsonResource(Resource resource) throws IOException {
        JsonParser parser = new JsonParser(Context.getCurrentContext(), (Scriptable)this.globalScope);
        try {
            Object result = parser.parseValue(resource.getContent());
            if (!(result instanceof Scriptable)) {
                throw new RuntimeException("Expected Object from package.json, got " + result);
            }
            return (Scriptable)result;
        }
        catch (JsonParser.ParseException px) {
            log.severe("Could not parse package.json " + resource.getUrl());
            throw new RuntimeException(px);
        }
    }

    private String getStringProperty(Scriptable obj, String name, String defaultValue) {
        Object value = ScriptableObject.getProperty((Scriptable)obj, (String)name);
        if (value != null && value != ScriptableObject.NOT_FOUND) {
            return ScriptRuntime.toString((Object)value);
        }
        return defaultValue;
    }

    public Scriptable loadModule(Context cx, String moduleName, Scriptable loadingScope) throws IOException {
        return this.mainWorker.loadModule(cx, moduleName, loadingScope);
    }

    public String getMainModule() {
        return this.config.getMainModule();
    }

    public ModuleScope getMainModuleScope() {
        return this.mainScope;
    }

    public Object[] getArguments() {
        String[] args = this.config.getArguments();
        if (args == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] array = new Object[args.length];
        System.arraycopy(args, 0, array, 0, args.length);
        return array;
    }

    public String getCharset() {
        return this.config.getCharset();
    }

    public static RhinoEngine getEngine(Scriptable scope) {
        if (scope instanceof ModuleScope) {
            scope = scope.getPrototype();
        }
        if (scope instanceof RingoGlobal) {
            return ((RingoGlobal)scope).getEngine();
        }
        throw new IllegalArgumentException("Unsupported scope");
    }

    public RhinoEngine createSandbox(RingoConfig config, Map<String, Object> globals) throws Exception {
        config.setPolicyEnabled(this.config.isPolicyEnabled());
        return new RhinoEngine(config, globals);
    }

    protected boolean isPolicyEnabled() {
        return this.config.isPolicyEnabled();
    }

    public void waitForAsyncTasks() throws InterruptedException {
        this.asyncCounter.waitTillDone();
    }

    protected void enterAsyncTask() {
        this.asyncCounter.increase();
    }

    protected void exitAsyncTask() {
        this.asyncCounter.decrease();
    }

    private Map<Trackable, ReloadableScript> getScriptCache(Context cx) {
        return cx.getOptimizationLevel() == -1 ? this.interpretedScripts : this.compiledScripts;
    }

    private void evaluateBootstrapScripts(Context cx) throws IOException {
        List<String> bootstrapScripts = this.config.getBootstrapScripts();
        if (bootstrapScripts != null) {
            for (String script : bootstrapScripts) {
                Resource resource = new FileResource(script);
                if (!resource.exists()) {
                    resource = this.getRingoHome().getResource(script);
                }
                if (resource == null || !resource.exists()) {
                    throw new FileNotFoundException("Bootstrap script " + script + " not found");
                }
                this.mainWorker.evaluateScript(cx, new ReloadableScript(resource, this), (Scriptable)this.globalScope);
            }
        }
    }

    public List<String> getCommandLineArguments() {
        if (this.commandLineArgs == null) {
            this.commandLineArgs = Collections.emptyList();
        }
        return Collections.unmodifiableList(this.commandLineArgs);
    }

    public List<Repository> getRepositories() {
        return this.repositories;
    }

    public Repository getRingoHome() {
        return this.config.getRingoHome();
    }

    public Repository getParentRepository(Scriptable scope) {
        while (scope != null) {
            if (scope instanceof ModuleScope) {
                return ((ModuleScope)scope).getRepository();
            }
            scope = scope.getPrototype();
        }
        return null;
    }

    public List<Resource> findResources(String path, boolean recursive) throws IOException {
        return this.config.getResources(path, recursive);
    }

    public Trackable resolve(String path, Repository localRoot) throws IOException {
        Trackable t = this.findResource(path, null, localRoot);
        if (t == null || !t.exists()) {
            t = this.findRepository(path, localRoot);
        }
        return t;
    }

    public Resource findResource(String path, ModuleLoader[] loaders, Repository localRoot) throws IOException {
        File file = new File(path);
        if (file.isAbsolute()) {
            FileResource res;
            block7: {
                if (loaders != null) {
                    assert (loaders.length > 0 && loaders[0] != null);
                    for (ModuleLoader loader : loaders) {
                        res = new FileResource(path + loader.getExtension());
                        if (!res.exists()) {
                            continue;
                        }
                        break block7;
                    }
                    res = new FileResource(path + loaders[0].getExtension());
                } else {
                    res = new FileResource(file);
                }
            }
            res.setAbsolute(true);
            return res;
        }
        if (localRoot != null && (path.startsWith("./") || path.startsWith("../"))) {
            String newpath = localRoot.getRelativePath() + path;
            return this.findResource(newpath, loaders, null);
        }
        return this.config.getResource(RhinoEngine.normalizePath(path), loaders);
    }

    public Repository findRepository(String path, Repository localPath) throws IOException {
        Repository repository;
        File file = new File(path);
        if (file.isAbsolute()) {
            return new FileRepository(file);
        }
        if (localPath != null && (repository = localPath.getChildRepository(path)) != null && repository.exists()) {
            return repository;
        }
        return this.config.getRepository(RhinoEngine.normalizePath(path));
    }

    public ModuleLoader getModuleLoader(Resource resource) {
        String name = resource.getName();
        for (ModuleLoader loader : this.loaders) {
            if (!name.endsWith(loader.getExtension())) continue;
            return loader;
        }
        return this.loaders[0];
    }

    public synchronized void addModuleLoader(String extension, Object value) {
        if (value == null || value == Undefined.instance) {
            this.removeModuleLoader(extension);
        } else if (!(value instanceof Function)) {
            throw Context.reportRuntimeError((String)"Module loader must be a function");
        }
        Function function = (Function)value;
        int length = this.loaders.length;
        for (int i = 0; i < length; ++i) {
            if (!extension.equals(this.loaders[i].getExtension())) continue;
            this.loaders[i] = new ScriptedModuleLoader(extension, function);
            return;
        }
        ModuleLoader[] newLoaders = new ModuleLoader[length + 1];
        System.arraycopy(this.loaders, 0, newLoaders, 0, length);
        newLoaders[length] = new ScriptedModuleLoader(extension, function);
        this.loaders = newLoaders;
    }

    public synchronized void removeModuleLoader(String extension) {
        int length = this.loaders.length;
        for (int i = 0; i < length; ++i) {
            if (!(this.loaders[i] instanceof ScriptedModuleLoader) || !extension.equals(this.loaders[i].getExtension())) continue;
            ModuleLoader[] newLoaders = new ModuleLoader[length - 1];
            if (i > 0) {
                System.arraycopy(this.loaders, 0, newLoaders, 0, i);
            }
            if (i < length - 1) {
                System.arraycopy(this.loaders, i + 1, newLoaders, i, length - i - 1);
            }
            this.loaders = newLoaders;
            return;
        }
    }

    public static String normalizePath(String path) {
        if (!path.contains("./")) {
            return path;
        }
        boolean absolute = path.startsWith("/");
        String[] elements = StringUtils.split(path, Repository.SEPARATOR);
        LinkedList<String> list = new LinkedList<String>();
        for (String e : elements) {
            if ("..".equals(e)) {
                if (list.isEmpty() || "..".equals(list.getLast())) {
                    list.add(e);
                    continue;
                }
                list.removeLast();
                continue;
            }
            if (".".equals(e) || e.length() <= 0) continue;
            list.add(e);
        }
        StringBuilder sb = new StringBuilder(path.length());
        if (absolute) {
            sb.append("/");
        }
        int count = 0;
        int last = list.size() - 1;
        for (String e : list) {
            sb.append(e);
            if (count++ >= last) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public void addToClasspath(Trackable path) throws MalformedURLException {
        this.loader.addURL(path.getUrl());
    }

    public RingoContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public RingoClassLoader getClassLoader() {
        return this.loader;
    }

    public RingoConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Singleton getSingleton(Singleton singleton) {
        Map<Singleton, Singleton> map = this.singletons;
        synchronized (map) {
            Singleton st = this.singletons.get(singleton);
            if (st == null) {
                st = singleton;
                this.singletons.put(singleton, singleton);
            }
            return st;
        }
    }

    public Object asJavaString(Object object) {
        if (!(object instanceof String)) {
            object = object.toString();
        }
        Context cx = Context.getCurrentContext();
        return this.wrapFactory.wrapAsJavaObject(cx, (Scriptable)this.globalScope, object, null);
    }

    public Object asJavaObject(Object object) {
        if (object instanceof Wrapper) {
            object = ((Wrapper)object).unwrap();
        }
        Context cx = Context.getCurrentContext();
        return this.wrapFactory.wrapAsJavaObject(cx, (Scriptable)this.globalScope, object, null);
    }

    public WrapFactory getWrapFactory() {
        return this.wrapFactory;
    }

    static class AsyncTaskCounter {
        int count = 0;

        AsyncTaskCounter() {
        }

        synchronized void waitTillDone() throws InterruptedException {
            while (this.count > 0) {
                this.wait();
            }
        }

        synchronized void increase() {
            ++this.count;
        }

        synchronized void decrease() {
            if (--this.count <= 0) {
                this.notifyAll();
            }
        }
    }
}

