/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.ringojs.engine.ModuleScope;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.engine.RingoGlobal;
import org.ringojs.engine.RingoWorker;
import org.ringojs.repository.FileRepository;
import org.ringojs.repository.Repository;
import org.ringojs.repository.ZipRepository;
import org.ringojs.util.ScriptUtils;
import org.ringojs.util.StringUtils;

public class Require
extends BaseFunction {
    RhinoEngine engine;
    RingoGlobal scope;
    static Method getMain;

    public Require(RhinoEngine engine, RingoGlobal scope) {
        super((Scriptable)scope, ScriptableObject.getClassPrototype((Scriptable)scope, (String)"Function"));
        this.engine = engine;
        this.scope = scope;
        int attr = 7;
        this.defineProperty("main", (Object)this, getMain, null, attr);
        this.defineProperty("paths", (Object)new ModulePath(), attr);
        this.defineProperty("extensions", (Object)new Extensions(), attr);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length != 1 || !(args[0] instanceof CharSequence)) {
            throw Context.reportRuntimeError((String)"require() expects a single string argument");
        }
        ModuleScope moduleScope = thisObj instanceof ModuleScope ? (ModuleScope)thisObj : null;
        try {
            RingoWorker worker = this.engine.getCurrentWorker(scope);
            String arg = args[0].toString();
            Scriptable module = worker.loadModule(cx, arg, (Scriptable)moduleScope);
            return module instanceof ModuleScope ? ((ModuleScope)module).getExports() : module;
        }
        catch (FileNotFoundException notFound) {
            throw Context.reportRuntimeError((String)("Cannot find module '" + args[0] + "'"));
        }
        catch (IOException iox) {
            throw Context.reportRuntimeError((String)("Error loading module '" + args[0] + "': " + iox));
        }
    }

    public int getArity() {
        return 1;
    }

    public Object getMain(ScriptableObject thisObj) {
        try {
            ModuleScope main = this.engine.getMainModuleScope();
            return main != null ? main.getModuleObject() : Undefined.instance;
        }
        catch (Exception x) {
            return Undefined.instance;
        }
    }

    static {
        try {
            getMain = Require.class.getDeclaredMethod("getMain", ScriptableObject.class);
        }
        catch (NoSuchMethodException nsm) {
            throw new NoSuchMethodError("getMain");
        }
    }

    class ModulePath
    extends ScriptableObject {
        List<Repository> paths;
        Map<String, SoftReference<Repository>> cache = new HashMap<String, SoftReference<Repository>>();

        public ModulePath() {
            this.paths = Require.this.engine.getRepositories();
            for (Repository repo : this.paths) {
                this.cache.put(repo.getPath(), new SoftReference<Repository>(repo));
            }
            this.setParentScope((Scriptable)Require.this.scope);
            this.setPrototype(ScriptableObject.getClassPrototype((Scriptable)Require.this.scope, (String)"Array"));
            this.defineProperty("length", this.paths.size(), 2);
        }

        public String getClassName() {
            return "ModulePath";
        }

        public void put(int index, Scriptable start, Object value) {
            if (this.paths != null) {
                Repository repo;
                try {
                    repo = this.toRepository(value);
                }
                catch (IOException iox) {
                    throw new WrappedException((Throwable)iox);
                }
                while (index >= this.paths.size()) {
                    this.paths.add(null);
                }
                this.paths.set(index, repo);
                this.defineProperty("length", this.paths.size(), 2);
            } else {
                super.put(index, start, value);
            }
        }

        public void put(String id, Scriptable start, Object value) {
            if (this.paths != null && "length".equals(id)) {
                int length = ScriptUtils.toInt(value, -1);
                if (length < 0) {
                    throw Context.reportRuntimeError((String)("Invalid length value: " + value));
                }
                while (length > this.paths.size()) {
                    this.paths.add(null);
                }
                while (length < this.paths.size()) {
                    this.paths.remove(length);
                }
            }
            super.put(id, start, value);
        }

        public Object get(int index, Scriptable start) {
            if (this.paths != null) {
                Repository value = index < this.paths.size() ? this.paths.get(index) : null;
                return value == null ? NOT_FOUND : value.getPath();
            }
            return super.get(index, start);
        }

        public boolean has(int index, Scriptable start) {
            if (this.paths != null) {
                return index >= 0 && index < this.paths.size();
            }
            return super.has(index, start);
        }

        public Object[] getIds() {
            if (this.paths != null) {
                Object[] ids = new Object[this.paths.size()];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = i;
                }
                return ids;
            }
            return super.getIds();
        }

        private Repository toRepository(Object value) throws IOException {
            if (value instanceof Wrapper) {
                value = ((Wrapper)value).unwrap();
            }
            Repository repo = null;
            if (value instanceof Repository) {
                repo = (Repository)value;
                repo.setRoot();
                this.cache.put(repo.getPath(), new SoftReference<Repository>(repo));
            } else if (value != null && value != Undefined.instance) {
                String str = ScriptRuntime.toString((Object)value);
                SoftReference<Repository> ref = this.cache.get(str);
                Repository repository = repo = ref == null ? null : ref.get();
                if (repo == null) {
                    File file = new File(str);
                    repo = file.isFile() && StringUtils.isZipOrJarFile(str) ? new ZipRepository(str) : new FileRepository(str);
                    this.cache.put(repo.getPath(), new SoftReference<Repository>(repo));
                }
            } else {
                throw Context.reportRuntimeError((String)("Invalid module path item: " + value));
            }
            return repo;
        }
    }

    class Extensions
    extends NativeObject {
        public Extensions() {
            this.setParentScope((Scriptable)Require.this.scope);
            this.setPrototype(ScriptableObject.getClassPrototype((Scriptable)Require.this.scope, (String)"Object"));
        }

        public void put(String name, Scriptable start, Object value) {
            Require.this.engine.addModuleLoader(name, value);
            super.put(name, start, value);
        }

        public void delete(String name) {
            Require.this.engine.removeModuleLoader(name);
            super.delete(name);
        }
    }
}

