/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.ringojs.engine.ModuleLoader;
import org.ringojs.engine.ModuleScope;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.engine.RingoWorker;
import org.ringojs.engine.ScriptError;
import org.ringojs.repository.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadableScript {
    final Resource resource;
    final RhinoEngine engine;
    final String moduleName;
    ModuleLoader loader;
    boolean reloading;
    long checksum = -1L;
    ScriptReference scriptref;
    Exception exception = null;
    List<ScriptError> errors;
    private final CopyOnWriteArraySet<ReloadableScript> dependencies = new CopyOnWriteArraySet();
    static ScriptCache cache = new ScriptCache();
    private static Logger log = Logger.getLogger(ReloadableScript.class.getName());

    public ReloadableScript(Resource source, RhinoEngine engine) {
        source.setStripShebang(true);
        this.resource = source;
        this.engine = engine;
        this.loader = engine.getModuleLoader(source);
        this.reloading = engine.getConfig().isReloading();
        this.moduleName = source.getModuleName();
    }

    public Resource getSource() {
        return this.resource;
    }

    public synchronized Object getScript(Context cx, RingoWorker worker) throws JavaScriptException, IOException {
        List<ScriptError> currentErrors;
        int optlevel = cx.getOptimizationLevel();
        if (this.scriptref == null && optlevel > -1) {
            this.scriptref = cache.get(this.resource);
        }
        Object script = null;
        if (this.scriptref != null) {
            script = this.scriptref.get();
            this.checksum = this.scriptref.checksum;
            this.errors = this.scriptref.errors;
            this.exception = this.scriptref.exception;
        }
        if (script == null && this.exception == null || this.reloading && this.checksum != this.resource.getChecksum()) {
            if (!this.resource.exists()) {
                throw new FileNotFoundException(this.resource + " not found or not readable");
            }
            this.exception = null;
            this.errors = null;
            script = this.compileScript(cx);
            this.scriptref = cache.createReference(this.resource, script, this);
            if (optlevel > -1) {
                cache.put(this.resource, this.scriptref);
            }
        }
        if (this.errors != null && worker != null && !this.errors.isEmpty() && (currentErrors = worker.getErrors()) != null) {
            currentErrors.addAll(this.errors);
        }
        if (this.exception != null) {
            throw this.exception instanceof RhinoException ? (RhinoException)this.exception : new WrappedException((Throwable)this.exception);
        }
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object compileScript(Context cx) throws JavaScriptException, IOException {
        ErrorReporter errorReporter = cx.getErrorReporter();
        cx.setErrorReporter((ErrorReporter)new ErrorCollector());
        Object script = null;
        String charset = this.engine.getCharset();
        try {
            CodeSource securityDomain = this.engine.isPolicyEnabled() ? new CodeSource(this.resource.getUrl(), (CodeSigner[])null) : null;
            script = this.loader.load(cx, this.engine, securityDomain, this.moduleName, charset, this.resource);
        }
        catch (Exception x) {
            this.exception = x;
        }
        finally {
            cx.setErrorReporter(errorReporter);
            this.checksum = this.resource.getChecksum();
        }
        return script;
    }

    public Object evaluate(Scriptable scope, Context cx, RingoWorker worker) throws JavaScriptException, IOException {
        ModuleScope module;
        Object obj = this.getScript(cx, worker);
        if (!(obj instanceof Script)) {
            return obj;
        }
        Script script = (Script)obj;
        ModuleScope moduleScope = module = scope instanceof ModuleScope ? (ModuleScope)scope : null;
        if (module != null) {
            worker.registerModule(this.resource, (Scriptable)module);
        }
        Object value = script.exec(cx, scope);
        if (module != null) {
            module.updateExports();
            module.setChecksum(this.getChecksum());
        }
        return value;
    }

    protected Scriptable load(Scriptable prototype, Context cx, Scriptable module, RingoWorker worker) throws JavaScriptException, IOException {
        if (module instanceof ModuleScope && ((ModuleScope)module).getChecksum() == this.getChecksum()) {
            worker.registerModule(this.resource, module);
            return module;
        }
        return this.exec(cx, prototype, worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Scriptable exec(Context cx, Scriptable prototype, RingoWorker worker) throws IOException {
        ToolErrorReporter reporter;
        Object obj;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loading module: " + this.moduleName);
        }
        if (this.engine.getConfig().isVerbose()) {
            System.err.println("Loading module: " + this.moduleName);
        }
        if (!((obj = this.getScript(cx, worker)) instanceof Script)) {
            if (!(obj instanceof Scriptable)) {
                throw Context.reportRuntimeError((String)"Module must be an object");
            }
            Scriptable scriptable = (Scriptable)obj;
            worker.registerModule(this.resource, scriptable);
            return scriptable;
        }
        Script script = (Script)obj;
        ModuleScope module = new ModuleScope(this.moduleName, this.resource, prototype, worker);
        worker.registerModule(this.resource, (Scriptable)module);
        ErrorReporter er = cx.getErrorReporter();
        ToolErrorReporter toolErrorReporter = reporter = er instanceof ToolErrorReporter ? (ToolErrorReporter)er : null;
        if (reporter != null && !reporter.isReportingWarnings()) {
            try {
                reporter.setIsReportingWarnings(true);
                script.exec(cx, (Scriptable)module);
            }
            finally {
                reporter.setIsReportingWarnings(false);
            }
        } else {
            script.exec(cx, (Scriptable)module);
        }
        module.updateExports();
        module.setChecksum(this.getChecksum());
        return module;
    }

    protected long getChecksum() throws IOException {
        long cs = this.resource.getChecksum();
        HashSet<ReloadableScript> set = new HashSet<ReloadableScript>();
        set.add(this);
        for (ReloadableScript script : this.dependencies) {
            cs += script.getNestedChecksum(set);
        }
        return cs;
    }

    protected long getNestedChecksum(Set<ReloadableScript> set) throws IOException {
        if (set.contains(this)) {
            return 0L;
        }
        set.add(this);
        long cs = this.resource.getChecksum();
        for (ReloadableScript script : this.dependencies) {
            cs += script.getNestedChecksum(set);
        }
        return cs;
    }

    protected void addDependency(ReloadableScript script) {
        if (!this.dependencies.contains(script)) {
            this.dependencies.add(script);
        }
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ReloadableScript && this.resource.equals(((ReloadableScript)obj).resource);
    }

    static class ScriptCache {
        ConcurrentHashMap<Resource, ScriptReference> map = new ConcurrentHashMap();
        ReferenceQueue<Object> queue = new ReferenceQueue();

        ScriptCache() {
        }

        ScriptReference createReference(Resource source, Object script, ReloadableScript rlscript) throws IOException {
            return new ScriptReference(source, script, rlscript, this.queue);
        }

        ScriptReference get(Resource source) {
            ScriptReference ref;
            while ((ref = (ScriptReference)this.queue.poll()) != null) {
                this.map.remove(ref.source);
            }
            return this.map.get(source);
        }

        void put(Resource source, ScriptReference ref) throws IOException {
            this.map.put(source, ref);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ScriptReference
    extends SoftReference<Object> {
        Resource source;
        long checksum;
        List<ScriptError> errors;
        Exception exception;

        ScriptReference(Resource source, Object script, ReloadableScript rescript, ReferenceQueue<Object> queue) throws IOException {
            super(script, queue);
            this.source = source;
            this.checksum = rescript.checksum;
            this.errors = rescript.errors;
            this.exception = rescript.exception;
        }
    }

    class ErrorCollector
    implements ErrorReporter {
        ErrorCollector() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            System.err.println("Warning: " + new ScriptError(message, sourceName, line, lineSource, lineOffset));
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (ReloadableScript.this.errors == null) {
                ReloadableScript.this.errors = new ArrayList<ScriptError>();
            }
            ReloadableScript.this.errors.add(new ScriptError(message, sourceName, line, lineSource, lineOffset));
            String error = "SyntaxError";
            if (message.startsWith("TypeError: ")) {
                error = "TypeError";
                message = message.substring(11);
            }
            throw ScriptRuntime.constructError((String)error, (String)message, (String)sourceName, (int)line, (String)lineSource, (int)lineOffset);
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }
    }
}

