/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.ringojs.repository.AbstractResource;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;

class NotFound
extends AbstractResource
implements Repository {
    NotFound(String path) {
        this.path = path;
        int slash = path.lastIndexOf(47);
        this.name = slash < 0 ? path : path.substring(slash + 1);
        this.setBaseNameFromName(this.name);
    }

    public long getLength() {
        return 0L;
    }

    public InputStream getInputStream() throws IOException {
        throw new FileNotFoundException("\"" + this.path + "\" not found");
    }

    public long lastModified() {
        return 0L;
    }

    public boolean exists() {
        return false;
    }

    public Repository getChildRepository(String path) throws IOException {
        return this;
    }

    public Resource getResource(String resourceName) throws IOException {
        return this;
    }

    public Resource[] getResources() throws IOException {
        return new Resource[0];
    }

    public Resource[] getResources(boolean recursive) throws IOException {
        return new Resource[0];
    }

    public Resource[] getResources(String resourcePath, boolean recursive) throws IOException {
        return new Resource[0];
    }

    public Repository[] getRepositories() throws IOException {
        return new Repository[0];
    }

    public void setRoot() {
    }

    public URL getUrl() throws UnsupportedOperationException, MalformedURLException {
        throw new UnsupportedOperationException("Unable to resolve \"" + this.path + "\"");
    }

    public String toString() {
        return "Resource \"" + this.path + "\"";
    }
}

