/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.ringojs.engine.ModuleObject;
import org.ringojs.engine.RingoWorker;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Trackable;

public class ModuleScope
extends ImporterTopLevel {
    private Trackable source;
    private Repository repository;
    private String id;
    private RingoWorker worker;
    private long checksum;
    private Scriptable exportsObject;
    private Scriptable moduleObject;
    private static final long serialVersionUID = -2409425841990094897L;

    public ModuleScope(String moduleId, Trackable source, Scriptable prototype, RingoWorker worker) {
        this.setParentScope(null);
        this.setPrototype(prototype);
        this.activatePrototypeMap(3);
        this.delete("constructor");
        try {
            this.cacheBuiltins();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.source = source;
        this.repository = source instanceof Repository ? (Repository)source : source.getParentRepository();
        this.id = moduleId;
        this.worker = worker;
        this.moduleObject = new ModuleObject(this);
        this.defineProperty("module", this.moduleObject, 2);
        this.exportsObject = new ExportsObject();
        this.defineProperty("exports", this.exportsObject, 2);
        this.moduleObject.put("exports", this.moduleObject, (Object)this.exportsObject);
    }

    public Trackable getSource() {
        return this.source;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public RingoWorker getWorker() {
        return this.worker;
    }

    public void reset() {
        ExportsObject exports = new ExportsObject();
        this.defineProperty("exports", (Object)exports, 2);
        this.moduleObject.put("exports", this.moduleObject, (Object)exports);
        this.moduleObject.delete("shared");
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public String getModuleName() {
        return this.id;
    }

    protected void updateExports() {
        this.exportsObject = ScriptRuntime.toObject((Scriptable)this, (Object)ScriptableObject.getProperty((Scriptable)this.moduleObject, (String)"exports"));
    }

    public Scriptable getExports() {
        return this.exportsObject;
    }

    public Scriptable getModuleObject() {
        return this.moduleObject;
    }

    public String toString() {
        return "[ModuleScope " + this.source + "]";
    }

    public Object getDefaultValue(Class hint) {
        if (hint == String.class || hint == null) {
            return this.toString();
        }
        return super.getDefaultValue(hint);
    }

    class ExportsObject
    extends NativeObject {
        ExportsObject() {
            this.setParentScope((Scriptable)ModuleScope.this);
            this.setPrototype(ExportsObject.getObjectPrototype((Scriptable)ModuleScope.this));
        }

        public String getModuleName() {
            return ModuleScope.this.id;
        }
    }
}

