/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import java.io.IOException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.ringojs.engine.ModuleScope;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.engine.Singleton;
import org.ringojs.repository.FileResource;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;
import org.ringojs.repository.Trackable;

public class ModuleObject
extends ScriptableObject {
    String id;
    Trackable source;
    Repository repository;

    public ModuleObject() {
    }

    ModuleObject(ModuleScope moduleScope) {
        this.setParentScope((Scriptable)moduleScope);
        this.setPrototype(ScriptableObject.getClassPrototype((Scriptable)moduleScope, (String)"ModuleObject"));
        this.id = moduleScope.getModuleName();
        this.source = moduleScope.getSource();
        this.repository = moduleScope.getRepository();
    }

    @JSFunction
    public String resolve(Object path) throws IOException {
        String _path;
        String string = _path = path == null || path == Undefined.instance ? "" : ScriptRuntime.toString((Object)path);
        if (this.repository == null) {
            return _path;
        }
        Resource res = this.repository.getResource(_path);
        if (res == null) {
            return _path;
        }
        if (res instanceof FileResource) {
            return res.getPath();
        }
        return res.getRelativePath();
    }

    @JSFunction
    public Object singleton(Object id, Object factory) {
        if (!(id instanceof CharSequence)) {
            throw ScriptRuntime.constructError((String)"Error", (String)"singleton() requires a string id as first argument");
        }
        Function factoryFunction = null;
        if (factory instanceof Function) {
            factoryFunction = (Function)factory;
        } else if (factory != Undefined.instance && factory != null) {
            throw ScriptRuntime.constructError((String)"Error", (String)"Expected function as second argument");
        }
        Scriptable scope = ScriptableObject.getTopLevelScope((Scriptable)this.getParentScope());
        RhinoEngine engine = RhinoEngine.getEngine(scope);
        Singleton singleton = engine.getSingleton(new Singleton(this.source, id.toString()));
        return singleton.getValue(factoryFunction, scope, this);
    }

    @JSGetter
    public Object getId() {
        return this.id == null ? Undefined.instance : this.id;
    }

    @JSGetter
    public Object getPath() {
        return this.source == null ? Undefined.instance : this.source.getPath();
    }

    @JSGetter
    public Object getUri() {
        try {
            return this.source == null ? Undefined.instance : this.source.getUrl().toString();
        }
        catch (Exception x) {
            return Undefined.instance;
        }
    }

    @JSGetter
    public Object getDirectory() {
        return this.repository == null ? Undefined.instance : this.repository.getPath();
    }

    protected Object equivalentValues(Object value) {
        if (value instanceof String) {
            return value.equals(this.id) ? Boolean.TRUE : Boolean.FALSE;
        }
        return NOT_FOUND;
    }

    public String getClassName() {
        return "ModuleObject";
    }
}

