/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.ringojs.engine.ModuleLoader;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.repository.Resource;

class JsModuleLoader
extends ModuleLoader {
    public JsModuleLoader() {
        super(".js");
    }

    public Object load(final Context cx, RhinoEngine engine, final Object securityDomain, String moduleName, final String charset, final Resource resource) throws Exception {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                InputStream aStream = null;
                InputStreamReader aReader = null;
                try {
                    aStream = resource.getInputStream();
                    aReader = new InputStreamReader(aStream, charset);
                    Script script = cx.compileReader((Reader)aReader, resource.getRelativePath(), resource.getLineNumber(), securityDomain);
                    return script;
                }
                catch (IOException iox) {
                    throw new RuntimeException(iox);
                }
                finally {
                    if (aReader != null) {
                        try {
                            aReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (aStream != null) {
                        try {
                            aStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }
}

