/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import java.io.IOException;
import java.io.InputStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.SecurityController;
import org.ringojs.engine.ModuleLoader;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.repository.Resource;

class ClassModuleLoader
extends ModuleLoader {
    public ClassModuleLoader() {
        super(".class");
    }

    public Object load(Context cx, RhinoEngine engine, Object securityDomain, String moduleName, String charset, Resource resource) throws Exception {
        long l = resource.getLength();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("File too large: " + l);
        }
        int length = (int)l;
        byte[] bytes = new byte[length];
        InputStream input = resource.getInputStream();
        try {
            int offset;
            int read;
            for (offset = 0; offset < length && (read = input.read(bytes, offset, length - offset)) >= 0; offset += read) {
            }
            if (offset < length) {
                throw new IOException("Could not read file completely");
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        String className = moduleName.replaceAll("/", ".");
        ClassLoader rhinoLoader = this.getClass().getClassLoader();
        GeneratedClassLoader loader = SecurityController.createLoader((ClassLoader)rhinoLoader, (Object)securityDomain);
        Class clazz = loader.defineClass(className, bytes);
        loader.linkClass(clazz);
        if (!Script.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("Module must be a Rhino script class");
        }
        return clazz.newInstance();
    }
}

