/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.engine;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.engine.RingoWorker;

public class Callback {
    RhinoEngine engine;
    RingoWorker worker;
    final Object module;
    final Object function;
    final boolean sync;

    public Callback(Scriptable function, RhinoEngine engine, boolean sync) {
        this.engine = engine;
        Scriptable scope = ScriptableObject.getTopLevelScope((Scriptable)function);
        if (function instanceof Function) {
            this.module = scope;
            this.function = function;
            this.worker = engine.getCurrentWorker(function);
        } else {
            this.module = ScriptableObject.getProperty((Scriptable)function, (String)"module");
            this.function = ScriptableObject.getProperty((Scriptable)function, (String)"name");
            if (this.module == Scriptable.NOT_FOUND || this.module == null) {
                throw Context.reportRuntimeError((String)"Callback object must contain 'module' property");
            }
            if (this.function == Scriptable.NOT_FOUND || this.function == null) {
                throw Context.reportRuntimeError((String)"Callback object must contain 'name' property");
            }
            this.worker = null;
        }
        this.sync = sync;
    }

    public boolean equalsCallback(Scriptable callback) {
        if (callback instanceof Function) {
            return this.function == callback;
        }
        return this.module.equals(ScriptableObject.getProperty((Scriptable)callback, (String)"module")) && this.function.equals(ScriptableObject.getProperty((Scriptable)callback, (String)"name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object ... args) {
        if (this.worker == null) {
            RingoWorker worker = this.engine.getWorker();
            try {
                Object object = this.invokeWithWorker(worker, args);
                return object;
            }
            finally {
                if (this.sync) {
                    worker.release();
                } else {
                    worker.releaseWhenDone();
                }
            }
        }
        return this.invokeWithWorker(this.worker, args);
    }

    private Object invokeWithWorker(RingoWorker worker, Object ... args) {
        if (this.sync) {
            try {
                return worker.invoke(this.module, this.function, args);
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return worker.submit(this.module, this.function, args);
    }
}

