/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test;

import io.ebean.DB;
import io.ebean.Transaction;
import io.ebeaninternal.api.HelpScopeTrans;

public class ForTests {
    public static void enableTransactional(boolean enable) {
        HelpScopeTrans.setEnabled((boolean)enable);
    }

    public static void noTransactional(Runnable run) {
        try {
            ForTests.enableTransactional(false);
            run.run();
        }
        finally {
            ForTests.enableTransactional(true);
        }
    }

    public static void rollbackAll(Runnable run) {
        try (Transaction transaction = DB.beginTransaction();){
            transaction.setNestedUseSavepoint();
            run.run();
            transaction.rollback();
        }
    }

    public static RollbackAll createRollbackAll() {
        Transaction transaction = DB.beginTransaction();
        transaction.setNestedUseSavepoint();
        return new RollbackAll(transaction);
    }

    public static class RollbackAll
    implements AutoCloseable {
        private final Transaction transaction;

        private RollbackAll(Transaction transaction) {
            this.transaction = transaction;
        }

        @Override
        public void close() {
            this.transaction.rollback();
        }
    }
}

