/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test;

import io.ebean.DB;
import io.ebean.test.IOUtils;
import io.ebean.test.Json;
import org.assertj.core.api.Assertions;

public class DbJson {
    public static PrettyJson of(Object bean) {
        return new PrettyJson(DB.json().toJsonPretty(bean));
    }

    public static String readResource(String resourcePath) {
        return IOUtils.readResource(resourcePath);
    }

    public static class PrettyJson {
        private String placeHolder = "\"*\"";
        private String rawJson;

        PrettyJson(String rawJson) {
            this.rawJson = rawJson;
        }

        public PrettyJson withPlaceholder(String placeHolder) {
            this.placeHolder = placeHolder;
            return this;
        }

        public PrettyJson replace(String ... propertyNames) {
            for (String propertyName : propertyNames) {
                String placeholder = "\"" + propertyName + "\": " + this.placeHolder;
                this.rawJson = this.rawJson.replaceAll("\"" + propertyName + "\": (\\d+)", placeholder);
                this.rawJson = this.rawJson.replaceAll("\"" + propertyName + "\": \"(.*?)\"", placeholder);
            }
            return this;
        }

        public String asJson() {
            return this.rawJson;
        }

        public void assertContentMatches(String resourcePath) {
            Assertions.assertThat((String)this.lineEnd(this.rawJson)).isEqualTo(this.lineEnd(DbJson.readResource(resourcePath)));
        }

        private String lineEnd(String content) {
            return content.replace("\r\n", "\n");
        }

        public void assertContains(String json) {
            Json.assertContains(this.rawJson, json);
        }

        public void assertContainsResource(String resourcePath) {
            this.assertContains(DbJson.readResource(resourcePath));
        }
    }
}

