/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.commands.DbContainer;
import java.sql.Connection;

public abstract class JdbcBaseDbContainer
extends DbContainer {
    JdbcBaseDbContainer(DbConfig config) {
        super(config);
        this.checkConnectivityUsingAdmin = true;
    }

    abstract void createDatabase();

    abstract void dropCreateDatabase();

    @Override
    public boolean startWithCreate() {
        if (!this.startContainerWithWait()) {
            return false;
        }
        this.createDatabase();
        return true;
    }

    @Override
    public boolean startWithDropCreate() {
        if (!this.startContainerWithWait()) {
            return false;
        }
        this.dropCreateDatabase();
        return true;
    }

    private boolean startContainerWithWait() {
        if (this.checkAlreadyRunning()) {
            this.dbConfig.clearStopMode();
            return true;
        }
        this.startIfNeeded();
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    protected boolean checkAlreadyRunning() {
        boolean bl;
        block8: {
            Connection connection = this.dbConfig.createAdminConnection();
            try {
                bl = true;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    @Override
    public boolean waitForDatabaseReady() {
        return true;
    }

    @Override
    protected boolean isDatabaseReady() {
        return true;
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return true;
    }
}

