/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.maven;

import io.ebean.enhance.Transformer;
import io.ebean.enhance.ant.OfflineFileTransform;
import io.ebean.enhance.ant.TransformationListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

abstract class AbstractEnhance
extends AbstractMojo {
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    List<String> compileClasspathElements;
    @Parameter(name="transformArgs")
    String transformArgs;
    @Parameter(name="packages")
    String packages;

    AbstractEnhance() {
    }

    public abstract void execute() throws MojoExecutionException;

    protected void executeFor(String classSource) throws MojoExecutionException {
        ClassLoader loader = this.buildClassLoader(classSource);
        this.getLog().info((CharSequence)("classLoaderClass=" + loader.getClass() + "  packages=" + loader));
        Transformer transformer = new Transformer(loader, this.transformArgs);
        this.getLog().info((CharSequence)("classSource=" + classSource + "  transformArgs=" + this.nullToEmpty(this.transformArgs) + "  packages=" + this.nullToEmpty(this.packages)));
        OfflineFileTransform ft = new OfflineFileTransform(transformer, loader, classSource);
        ft.setListener(new TransformationListener(){

            public void logEvent(String msg) {
                AbstractEnhance.this.getLog().info((CharSequence)msg);
            }

            public void logError(String msg) {
                AbstractEnhance.this.getLog().error((CharSequence)msg);
            }
        });
        ft.process(this.packages);
        List profilingKeys = transformer.getTransactionProfilingKeys();
        if (profilingKeys != null && !profilingKeys.isEmpty()) {
            this.getLog().info((CharSequence)("transaction profiling keys - " + profilingKeys));
        }
    }

    private String nullToEmpty(String val) {
        return val == null ? "" : val;
    }

    private ClassLoader buildClassLoader(String classSource) {
        URL[] urls = this.buildClassPath(classSource);
        return URLClassLoader.newInstance(urls, Thread.currentThread().getContextClassLoader());
    }

    private URL[] buildClassPath(String classSource) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>(this.compileClasspathElements.size());
            Log log = this.getLog();
            for (String element : this.compileClasspathElements) {
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("ClasspathElement: " + element));
                }
                urls.add(new File(element).toURI().toURL());
            }
            log.debug((CharSequence)("add source: " + classSource));
            urls.add(new File(classSource).toURI().toURL());
            return urls.toArray(new URL[urls.size()]);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

