/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.ehcache;

import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.EhcacheDecoratorAdapter;

public class InstrumentedEhcache
extends EhcacheDecoratorAdapter {
    private final Timer getTimer;
    private final Timer putTimer;

    public static Ehcache instrument(MetricRegistry registry, Ehcache cache) {
        MetricName prefix = MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName()});
        registry.registerGauge(prefix.resolve(new String[]{"hits"}), () -> cache.getStatistics().cacheHitCount());
        registry.registerGauge(prefix.resolve(new String[]{"in-memory-hits"}), () -> cache.getStatistics().localHeapHitCount());
        registry.registerGauge(prefix.resolve(new String[]{"off-heap-hits"}), () -> cache.getStatistics().localOffHeapHitCount());
        registry.registerGauge(prefix.resolve(new String[]{"on-disk-hits"}), () -> cache.getStatistics().localDiskHitCount());
        registry.registerGauge(prefix.resolve(new String[]{"misses"}), () -> cache.getStatistics().cacheMissCount());
        registry.registerGauge(prefix.resolve(new String[]{"in-memory-misses"}), () -> cache.getStatistics().localHeapMissCount());
        registry.registerGauge(prefix.resolve(new String[]{"off-heap-misses"}), () -> cache.getStatistics().localOffHeapMissCount());
        registry.registerGauge(prefix.resolve(new String[]{"on-disk-misses"}), () -> cache.getStatistics().localDiskMissCount());
        registry.registerGauge(prefix.resolve(new String[]{"objects"}), () -> cache.getStatistics().getSize());
        registry.registerGauge(prefix.resolve(new String[]{"in-memory-objects"}), () -> cache.getStatistics().getLocalHeapSize());
        registry.registerGauge(prefix.resolve(new String[]{"off-heap-objects"}), () -> cache.getStatistics().getLocalOffHeapSize());
        registry.registerGauge(prefix.resolve(new String[]{"on-disk-objects"}), () -> cache.getStatistics().getLocalDiskSize());
        registry.registerGauge(prefix.resolve(new String[]{"mean-get-time"}), () -> (Double)cache.getStatistics().cacheGetOperation().latency().average().value());
        registry.registerGauge(prefix.resolve(new String[]{"mean-search-time"}), () -> (Double)cache.getStatistics().cacheSearchOperation().latency().average().value());
        registry.registerGauge(prefix.resolve(new String[]{"eviction-count"}), () -> (Long)cache.getStatistics().cacheEvictionOperation().count().value());
        registry.registerGauge(prefix.resolve(new String[]{"searches-per-second"}), () -> (Double)cache.getStatistics().cacheSearchOperation().rate().value());
        registry.registerGauge(prefix.resolve(new String[]{"writer-queue-size"}), () -> cache.getStatistics().getWriterQueueLength());
        return new InstrumentedEhcache(registry, cache);
    }

    private InstrumentedEhcache(MetricRegistry registry, Ehcache cache) {
        super(cache);
        this.getTimer = registry.timer(MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName(), "gets"}));
        this.putTimer = registry.timer(MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName(), "puts"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Object key) throws IllegalStateException, CacheException {
        Timer.Context ctx = this.getTimer.time();
        try {
            Element element = this.underlyingCache.get(key);
            return element;
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Serializable key) throws IllegalStateException, CacheException {
        Timer.Context ctx = this.getTimer.time();
        try {
            Element element = this.underlyingCache.get(key);
            return element;
        }
        finally {
            ctx.stop();
        }
    }

    public void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        Timer.Context ctx = this.putTimer.time();
        try {
            this.underlyingCache.put(element);
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        Timer.Context ctx = this.putTimer.time();
        try {
            this.underlyingCache.put(element, doNotNotifyCacheReplicators);
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element putIfAbsent(Element element) throws NullPointerException {
        Timer.Context ctx = this.putTimer.time();
        try {
            Element element2 = this.underlyingCache.putIfAbsent(element);
            return element2;
        }
        finally {
            ctx.stop();
        }
    }
}

