/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.httpclient;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;

public class InstrumentedHttpClientConnectionManager
extends PoolingHttpClientConnectionManager {
    protected static Registry<ConnectionSocketFactory> getDefaultRegistry() {
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
    }

    public InstrumentedHttpClientConnectionManager(MetricRegistry metricRegistry) {
        this(metricRegistry, InstrumentedHttpClientConnectionManager.getDefaultRegistry());
    }

    public InstrumentedHttpClientConnectionManager(MetricRegistry metricsRegistry, Registry<ConnectionSocketFactory> socketFactoryRegistry) {
        this(metricsRegistry, socketFactoryRegistry, -1L, TimeUnit.MILLISECONDS);
    }

    public InstrumentedHttpClientConnectionManager(MetricRegistry metricsRegistry, Registry<ConnectionSocketFactory> socketFactoryRegistry, long connTTL, TimeUnit connTTLTimeUnit) {
        this(metricsRegistry, socketFactoryRegistry, null, null, (DnsResolver)SystemDefaultDnsResolver.INSTANCE, connTTL, connTTLTimeUnit, null);
    }

    public InstrumentedHttpClientConnectionManager(MetricRegistry metricsRegistry, Registry<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, long connTTL, TimeUnit connTTLTimeUnit, String name) {
        super(socketFactoryRegistry, connFactory, schemePortResolver, dnsResolver, connTTL, connTTLTimeUnit);
        metricsRegistry.register(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{name, "available-connections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedHttpClientConnectionManager.this.getTotalStats().getAvailable();
            }
        });
        metricsRegistry.register(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{name, "leased-connections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedHttpClientConnectionManager.this.getTotalStats().getLeased();
            }
        });
        metricsRegistry.register(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{name, "max-connections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedHttpClientConnectionManager.this.getTotalStats().getMax();
            }
        });
        metricsRegistry.register(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{name, "pending-connections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedHttpClientConnectionManager.this.getTotalStats().getPending();
            }
        });
    }
}

