/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation.selfvalidating;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.validation.ConstraintValidatorContext;

public class ViolationCollector {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("\\$\\{");
    private boolean violationOccurred = false;
    private ConstraintValidatorContext context;

    public ViolationCollector(ConstraintValidatorContext context) {
        this.context = context;
    }

    public void addViolation(String message) {
        this.violationOccurred = true;
        String messageTemplate = this.escapeEl(message);
        this.context.buildConstraintViolationWithTemplate(messageTemplate).addConstraintViolation();
    }

    public void addViolation(String propertyName, String message) {
        this.violationOccurred = true;
        String messageTemplate = this.escapeEl(message);
        this.context.buildConstraintViolationWithTemplate(messageTemplate).addPropertyNode(propertyName).addConstraintViolation();
    }

    public void addViolation(String propertyName, Integer index, String message) {
        this.violationOccurred = true;
        String messageTemplate = this.escapeEl(message);
        this.context.buildConstraintViolationWithTemplate(messageTemplate).addPropertyNode(propertyName).addBeanNode().inIterable().atIndex(index).addConstraintViolation();
    }

    public void addViolation(String propertyName, String key, String message) {
        this.violationOccurred = true;
        String messageTemplate = this.escapeEl(message);
        this.context.buildConstraintViolationWithTemplate(messageTemplate).addPropertyNode(propertyName).addBeanNode().inIterable().atKey((Object)key).addConstraintViolation();
    }

    @Nullable
    private String escapeEl(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        Matcher m = ESCAPE_PATTERN.matcher(s);
        StringBuffer sb = new StringBuffer(s.length() + 16);
        while (m.find()) {
            m.appendReplacement(sb, "\\\\\\${");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public ConstraintValidatorContext getContext() {
        return this.context;
    }

    public boolean hasViolationOccurred() {
        return this.violationOccurred;
    }

    public void setViolationOccurred(boolean violationOccurred) {
        this.violationOccurred = violationOccurred;
    }
}

