/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.runtime;

import io.doov.core.CodeLookup;
import io.doov.core.CodeValuable;
import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.runtime.PathMethod;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class RuntimeField<B, R>
implements DslField<R>,
FieldInfo,
Function<B, R>,
BiConsumer<B, R> {
    private final List<PathMethod<Object, Object>> chain;
    private final PathMethod<Object, R> lastLink;
    private final FieldId id;
    private final String readable;
    private FieldId[] siblings;
    private Class<R> type;
    private final Class<?>[] genericTypes;
    private boolean isCodeLookup;
    private boolean isCodeValuable;
    private boolean isTransient;

    public RuntimeField(List<PathMethod<Object, Object>> chain, PathMethod<Object, R> lastLink, FieldId id, String readable, FieldId[] siblings, Class<R> type, Class<?>[] genericTypes, boolean isTransient) {
        this.chain = chain;
        this.lastLink = lastLink;
        this.id = id;
        this.readable = readable;
        this.siblings = siblings;
        this.type = type;
        this.genericTypes = genericTypes;
        this.isCodeLookup = CodeLookup.class.isAssignableFrom(type);
        this.isCodeValuable = CodeValuable.class.isAssignableFrom(type);
        this.isTransient = isTransient;
    }

    @Override
    public FieldId id() {
        return this.id;
    }

    @Override
    public String readable() {
        return this.readable;
    }

    @Override
    public DefaultCondition<R> getDefaultCondition() {
        return new DefaultCondition(this);
    }

    @Override
    public R apply(B b) {
        return this.get(b);
    }

    public R get(B model) {
        if (model == null) {
            return null;
        }
        Object next = model;
        for (PathMethod<Object, Object> m : this.chain) {
            next = m.get(next);
            if (next != null) continue;
            return null;
        }
        return this.lastLink.get(next);
    }

    @Override
    public void accept(B b, R r) {
        this.set(b, r);
    }

    public void set(B model, R value) {
        if (model == null) {
            return;
        }
        Object nextNode = model;
        for (PathMethod<Object, Object> method : this.chain) {
            Object methodReturn = method.get(nextNode);
            if (methodReturn == null) {
                if (value != null) {
                    nextNode = method.create(nextNode);
                    continue;
                }
                return;
            }
            nextNode = methodReturn;
        }
        this.lastLink.set(nextNode, value);
    }

    public RuntimeField<B, R> register(List<RuntimeField<B, Object>> registry) {
        registry.add(this);
        return this;
    }

    @Override
    public FieldId[] siblings() {
        return this.siblings;
    }

    public Class<R> type() {
        return this.type;
    }

    @Override
    public Class<?>[] genericTypes() {
        return this.genericTypes;
    }

    @Override
    public boolean isCodeLookup() {
        return this.isCodeLookup;
    }

    @Override
    public boolean isCodeValuable() {
        return this.isCodeValuable;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }
}

