/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.runtime;

import io.doov.core.dsl.runtime.PathMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ListPathMethod<T, R>
implements PathMethod<T, R> {
    private final Supplier<R> supplier;
    private final Function<T, List<R>> readMethod;
    private final BiConsumer<T, List<R>> writeMethod;
    private final int position;

    public ListPathMethod(Supplier<R> supplier, Function<T, List<R>> readMethod, BiConsumer<T, List<R>> writeMethod, int position) {
        this.supplier = supplier;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.position = position;
    }

    @Override
    public R get(T link) {
        return Optional.ofNullable(this.readMethod.apply(link)).filter(l -> l.size() >= this.position).map(l -> l.get(this.position - 1)).orElse(null);
    }

    @Override
    public void set(T link, R value) {
        this.readMethod.apply(link).add(this.position - 1, value);
    }

    @Override
    public R create(T link) {
        List<R> list = this.readMethod.apply(link);
        if (list == null) {
            list = new ArrayList<R>();
            this.writeMethod.accept(link, list);
        }
        for (int i = 0; i <= this.position - 1; ++i) {
            if (list.size() > i) continue;
            list.add(i, null);
        }
        R r = this.supplier.get();
        list.set(this.position - 1, r);
        return r;
    }
}

