/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.MappingOperator;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class MappingMetadata
implements Metadata {
    private final Deque<Element> elements;
    private final MetadataType type;

    public MappingMetadata(MetadataType type) {
        this.elements = new ArrayDeque<Element>();
        this.type = type;
    }

    private MappingMetadata(Deque<Element> elements, MetadataType type) {
        this.elements = elements;
        this.type = type;
    }

    public static MappingMetadata mappings(MappingOperator operator) {
        return new MappingMetadata(MetadataType.MULTIPLE_MAPPING).operator(operator);
    }

    public static MappingMetadata mapping(DslField inField, DslField outField) {
        return new MappingMetadata(MetadataType.SINGLE_MAPPING).operator(MappingOperator.map).field(inField).operator(MappingOperator.to).field(outField);
    }

    public static MappingMetadata mapping(List<DslField> inFields, DslField outField) {
        return new MappingMetadata(MetadataType.SINGLE_MAPPING).operator(MappingOperator.map).fields(inFields).operator(MappingOperator.to).field(outField);
    }

    public static MappingMetadata mapping(Supplier<?> supplier, DslField outField) {
        return new MappingMetadata(MetadataType.SINGLE_MAPPING).operator(MappingOperator.map).value(supplier).operator(MappingOperator.to).field(outField);
    }

    private MappingMetadata fields(List<DslField> fields) {
        Iterator<DslField> iterator = fields.iterator();
        iterator.forEachRemaining(f -> {
            this.field((DslField)f);
            if (iterator.hasNext()) {
                this.operator(MappingOperator.and);
            }
        });
        return this;
    }

    public Stream<Element> stream() {
        return this.elements.stream();
    }

    private MappingMetadata value(Supplier<?> supplier) {
        return this.add(new Element(() -> String.valueOf(supplier.get()), ElementType.VALUE));
    }

    private MappingMetadata field(DslField readable) {
        return this.add(readable == null ? null : new Element(readable, ElementType.FIELD));
    }

    private MappingMetadata operator(MappingOperator op) {
        return this.add(op == null ? null : new Element(op, ElementType.OPERATOR));
    }

    private MappingMetadata add(Element element) {
        if (element != null) {
            this.elements.add(element);
        }
        return this;
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        visitor.start(this, depth);
        visitor.visit(this, depth);
        visitor.end(this, depth);
    }

    @Override
    public List<Element> flatten() {
        return new ArrayList<Element>(this.elements);
    }

    @Override
    public List<Metadata> children() {
        return Collections.emptyList();
    }

    @Override
    public String readable(Locale locale) {
        return AstVisitorUtils.astToString(this, locale);
    }

    @Override
    public MetadataType type() {
        return this.type;
    }

    @Override
    public Metadata message(Context context) {
        return this;
    }
}

