/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.mapping;

import io.doov.core.FieldModel;
import io.doov.core.dsl.lang.MappingRule;
import io.doov.core.dsl.meta.MappingMetadata;
import io.doov.core.dsl.meta.MappingOperator;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MappingRegistry
implements MappingRule {
    private static final MappingMetadata REGISTRY_METADATA = MappingMetadata.mappings(MappingOperator.mappings);
    private final List<MappingRule> mappingRules;

    public static MappingRegistry mappings(MappingRule ... mappingRules) {
        return new MappingRegistry(mappingRules);
    }

    private MappingRegistry(MappingRule ... mappingRules) {
        this.mappingRules = Arrays.stream(mappingRules).flatMap(MappingRule::stream).collect(Collectors.toList());
    }

    public MappingRegistry with(MappingRule ... rulestoAdd) {
        return new MappingRegistry((MappingRule[])Stream.concat(this.mappingRules.stream(), Arrays.stream(rulestoAdd)).toArray(MappingRule[]::new));
    }

    public void validateAndExecute(FieldModel inModel, FieldModel outModel) {
        this.mappingRules.stream().filter(m -> m.validate(inModel, outModel)).forEach(m -> m.executeOn(inModel, outModel));
    }

    public boolean isEmpty() {
        return this.mappingRules.isEmpty();
    }

    @Override
    public boolean validate(FieldModel inModel, FieldModel outModel) {
        return this.mappingRules.stream().allMatch(m -> m.validate(inModel, outModel));
    }

    @Override
    public void executeOn(FieldModel inModel, FieldModel outModel) {
        for (MappingRule rule : this.mappingRules) {
            rule.executeOn(inModel, outModel);
        }
    }

    @Override
    public Stream<MappingRule> stream() {
        return this.mappingRules.stream();
    }

    @Override
    public String readable(Locale locale) {
        return AstVisitorUtils.astToString(this, locale);
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        visitor.start(REGISTRY_METADATA, depth);
        visitor.visit(REGISTRY_METADATA, depth);
        this.mappingRules.forEach(m -> m.accept(visitor, depth + 1));
        visitor.end(REGISTRY_METADATA, depth);
    }
}

