/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.impl.PredicateStepCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.PredicateMetadata;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

abstract class AbstractCondition<N>
implements Readable {
    protected final DslField field;
    protected final PredicateMetadata metadata;
    protected final BiFunction<DslModel, DslField, Optional<N>> value;
    protected final BiFunction<DslModel, Context, Optional<N>> function;

    protected AbstractCondition(DslField field) {
        this.field = field;
        this.metadata = LeafMetadata.fieldMetadata(field);
        this.value = (model, context) -> this.valueModel((DslModel)model, field);
        this.function = (model, context) -> this.valueModel((DslModel)model, field);
    }

    protected AbstractCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<N>> function) {
        this.field = field;
        this.metadata = metadata;
        this.value = (model, f) -> (Optional)function.apply((DslModel)model, (Context)null);
        this.function = function;
    }

    protected Optional<N> valueModel(DslModel model, DslField field) {
        return Optional.ofNullable(model.get(field.id()));
    }

    protected final Optional<N> value(DslModel model, DslField field) {
        return this.value.apply(model, field);
    }

    protected final StepCondition predicate(LeafMetadata metadata, Function<N, Boolean> predicate) {
        return new PredicateStepCondition<N>(this.metadata.merge(metadata), this.function, predicate);
    }

    protected final StepCondition predicate(LeafMetadata metadata, BiFunction<DslModel, Context, Optional<N>> value, BiFunction<N, N, Boolean> predicate) {
        return new PredicateStepCondition<N>(this.metadata.merge(metadata), this.function, value, predicate);
    }

    public PredicateMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String readable() {
        return this.metadata.readable();
    }
}

