/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.field.types;

import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.field.DelegatingFieldInfoImpl;
import io.doov.core.dsl.field.types.TemporalFieldInfo;
import io.doov.core.dsl.impl.LocalDateCondition;
import io.doov.core.dsl.impl.TemporalCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.PredicateMetadata;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.BiFunction;

public class DateIsoFieldInfo
extends DelegatingFieldInfoImpl
implements TemporalFieldInfo<LocalDate> {
    public DateIsoFieldInfo(FieldInfo fieldInfo) {
        super(fieldInfo);
    }

    public DateIsoCondition getTemporalCondition() {
        return new DateIsoCondition(this);
    }

    public static Optional<LocalDate> parse(DslModel model, FieldId id) {
        return Optional.ofNullable(model.get(id)).map(v -> LocalDate.parse(v, DateTimeFormatter.BASIC_ISO_DATE));
    }

    private class DateIsoCondition
    extends LocalDateCondition {
        private DateIsoCondition(DslField field) {
            super(field);
        }

        private DateIsoCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<LocalDate>> value) {
            super(field, metadata, value);
        }

        @Override
        protected TemporalCondition<LocalDate> temporalCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<LocalDate>> value) {
            return new DateIsoCondition(field, metadata, value);
        }

        @Override
        protected Optional<LocalDate> valueModel(DslModel model, DslField field) {
            return DateIsoFieldInfo.parse(model, field.id());
        }
    }
}

