/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.field;

import io.doov.core.FieldInfo;
import io.doov.core.dsl.field.FieldTypeProvider;
import io.doov.core.dsl.field.types.BooleanFieldInfo;
import io.doov.core.dsl.field.types.CharacterFieldInfo;
import io.doov.core.dsl.field.types.DoubleFieldInfo;
import io.doov.core.dsl.field.types.EnumFieldInfo;
import io.doov.core.dsl.field.types.FloatFieldInfo;
import io.doov.core.dsl.field.types.IntegerFieldInfo;
import io.doov.core.dsl.field.types.IterableFieldInfo;
import io.doov.core.dsl.field.types.LocalDateFieldInfo;
import io.doov.core.dsl.field.types.LocalDateTimeFieldInfo;
import io.doov.core.dsl.field.types.LocalTimeFieldInfo;
import io.doov.core.dsl.field.types.LongFieldInfo;
import io.doov.core.dsl.field.types.StringFieldInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

public class FieldTypes
implements FieldTypeProvider {
    private static final Map<Predicate<FieldInfo>, Class<? extends FieldInfo>> TYPES;

    @Override
    public Map<Predicate<FieldInfo>, Class<? extends FieldInfo>> getTypes() {
        return TYPES;
    }

    static {
        LinkedHashMap<Predicate<FieldInfo>, Class> map = new LinkedHashMap<Predicate<FieldInfo>, Class>();
        map.put(f -> f.type().equals(Boolean.class) || f.type().equals(Boolean.TYPE), BooleanFieldInfo.class);
        map.put(f -> f.type().equals(Character.class) || f.type().equals(Character.TYPE), CharacterFieldInfo.class);
        map.put(f -> f.type().equals(Double.class) || f.type().equals(Double.TYPE), DoubleFieldInfo.class);
        map.put(f -> Enum.class.isAssignableFrom(f.type()) || f.isCodeValuable(), EnumFieldInfo.class);
        map.put(f -> f.type().equals(Float.class) || f.type().equals(Float.TYPE), FloatFieldInfo.class);
        map.put(f -> f.type().equals(Integer.class) || f.type().equals(Integer.TYPE), IntegerFieldInfo.class);
        map.put(f -> f.type().equals(Long.class) || f.type().equals(Long.TYPE), LongFieldInfo.class);
        map.put(f -> Iterable.class.isAssignableFrom(f.type()), IterableFieldInfo.class);
        map.put(f -> f.type().equals(LocalDate.class), LocalDateFieldInfo.class);
        map.put(f -> f.type().equals(LocalTime.class), LocalTimeFieldInfo.class);
        map.put(f -> f.type().equals(LocalDateTime.class), LocalDateTimeFieldInfo.class);
        map.put(f -> f.type().equals(String.class), StringFieldInfo.class);
        TYPES = Collections.unmodifiableMap(map);
    }
}

