/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core;

import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.FieldModel;
import io.doov.core.serial.TypeAdapterRegistry;
import io.doov.core.serial.TypeAdapters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.Stream;

public class BaseFieldModel
implements FieldModel {
    private static TypeAdapterRegistry TYPE_ADAPTER_REGISTRY = new TypeAdapters();
    protected Map<FieldId, Object> values;
    protected List<FieldInfo> fieldInfos;
    private static final FieldId[] NO_SIBLINGS = new FieldId[0];

    public BaseFieldModel(List<FieldInfo> fieldInfos) {
        this(new HashMap<FieldId, Object>(), fieldInfos);
    }

    public BaseFieldModel(Map<FieldId, Object> values, List<FieldInfo> fieldInfos) {
        this.values = values;
        this.fieldInfos = fieldInfos;
    }

    public BaseFieldModel(FieldModel fieldModel) {
        this(fieldModel.getFieldInfos());
        this.setAll(fieldModel);
    }

    public Map<FieldId, Object> asMap() {
        return new HashMap<FieldId, Object>(this.values);
    }

    @Override
    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public TypeAdapterRegistry getTypeAdapterRegistry() {
        return TYPE_ADAPTER_REGISTRY;
    }

    @Override
    public <T> T get(FieldId fieldId) {
        return (T)this.values.get(fieldId);
    }

    public void set(FieldId fieldId, Object value) {
        this.values.put(fieldId, value);
        Arrays.stream(this.siblingsOf(fieldId)).forEach(s -> this.values.put((FieldId)s, value));
    }

    private FieldId[] siblingsOf(FieldId fieldId) {
        Optional<FieldInfo> sublings = this.fieldInfos.stream().filter(info -> info.id() == fieldId).findFirst();
        return sublings.isPresent() ? sublings.get().siblings() : NO_SIBLINGS;
    }

    @Override
    public Iterator<Map.Entry<FieldId, Object>> iterator() {
        return this.values.entrySet().iterator();
    }

    @Override
    public Spliterator<Map.Entry<FieldId, Object>> spliterator() {
        return new HashSet<Map.Entry<FieldId, Object>>(this.values.entrySet()).spliterator();
    }

    @Override
    public Stream<Map.Entry<FieldId, Object>> stream() {
        return new HashSet<Map.Entry<FieldId, Object>>(this.values.entrySet()).stream();
    }

    @Override
    public Stream<Map.Entry<FieldId, Object>> parallelStream() {
        return new HashSet<Map.Entry<FieldId, Object>>(this.values.entrySet()).parallelStream();
    }
}

