/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import io.digdag.client.config.Config;
import io.digdag.core.repository.ModelValidator;
import io.digdag.core.session.TaskType;
import io.digdag.core.workflow.ImmutableWorkflowTask;
import java.util.List;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableWorkflowTask.class)
@JsonDeserialize(as=ImmutableWorkflowTask.class)
@Value.Immutable
public abstract class WorkflowTask {
    public abstract String getName();

    public abstract String getFullName();

    public abstract int getIndex();

    public abstract Optional<Integer> getParentIndex();

    public abstract List<Integer> getUpstreamIndexes();

    public abstract TaskType getTaskType();

    public abstract Config getConfig();

    @Value.Check
    protected void check() {
        ModelValidator.builder().checkRawTaskName("name", this.getName()).check("task index", this.getIndex(), this.getIndex() >= 0, "must not be negative").validate("workflow task", this);
    }

    public static class Builder
    extends ImmutableWorkflowTask.Builder {
    }
}

