/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.digdag.client.config.Config;
import io.digdag.core.repository.ModelValidator;
import io.digdag.core.workflow.ImmutableWorkflow;
import io.digdag.core.workflow.WorkflowTaskList;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableWorkflow.class)
@JsonDeserialize(as=ImmutableWorkflow.class)
@Value.Immutable
public abstract class Workflow {
    public abstract String getName();

    public abstract Config getMeta();

    public abstract WorkflowTaskList getTasks();

    public static ImmutableWorkflow.Builder builder() {
        return ImmutableWorkflow.builder();
    }

    public static Workflow of(String name, Config meta, WorkflowTaskList tasks) {
        return ImmutableWorkflow.builder().name(name).meta(meta).tasks(tasks).build();
    }

    @Value.Check
    protected void check() {
        ModelValidator.builder().checkWorkflowName("name", this.getName()).check("tasks", this.getTasks(), !this.getTasks().isEmpty(), "must not be empty").validate("workflow", this);
    }
}

