/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.session.SessionMonitor;
import io.digdag.core.workflow.AttemptRequest;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableAttemptRequest
extends AttemptRequest {
    private final AttemptRequest.Stored stored;
    private final String workflowName;
    private final Instant sessionTime;
    private final ZoneId timeZone;
    private final Config sessionParams;
    private final ImmutableList<SessionMonitor> sessionMonitors;
    private final Optional<String> retryAttemptName;
    private final Optional<Long> resumingAttemptId;
    private final ImmutableList<Long> resumingTasks;

    private ImmutableAttemptRequest(AttemptRequest.Stored stored, String workflowName, Instant sessionTime, ZoneId timeZone, Config sessionParams, ImmutableList<SessionMonitor> sessionMonitors, Optional<String> retryAttemptName, Optional<Long> resumingAttemptId, ImmutableList<Long> resumingTasks) {
        this.stored = stored;
        this.workflowName = workflowName;
        this.sessionTime = sessionTime;
        this.timeZone = timeZone;
        this.sessionParams = sessionParams;
        this.sessionMonitors = sessionMonitors;
        this.retryAttemptName = retryAttemptName;
        this.resumingAttemptId = resumingAttemptId;
        this.resumingTasks = resumingTasks;
    }

    @Override
    @JsonProperty(value="stored")
    public AttemptRequest.Stored getStored() {
        return this.stored;
    }

    @Override
    @JsonProperty(value="workflowName")
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Override
    @JsonProperty(value="sessionTime")
    public Instant getSessionTime() {
        return this.sessionTime;
    }

    @Override
    @JsonProperty(value="timeZone")
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    @JsonProperty(value="sessionParams")
    public Config getSessionParams() {
        return this.sessionParams;
    }

    @JsonProperty(value="sessionMonitors")
    public ImmutableList<SessionMonitor> getSessionMonitors() {
        return this.sessionMonitors;
    }

    @Override
    @JsonProperty(value="retryAttemptName")
    public Optional<String> getRetryAttemptName() {
        return this.retryAttemptName;
    }

    @Override
    @JsonProperty(value="resumingAttemptId")
    public Optional<Long> getResumingAttemptId() {
        return this.resumingAttemptId;
    }

    @JsonProperty(value="resumingTasks")
    public ImmutableList<Long> getResumingTasks() {
        return this.resumingTasks;
    }

    public final ImmutableAttemptRequest withStored(AttemptRequest.Stored value) {
        if (this.stored == value) {
            return this;
        }
        AttemptRequest.Stored newValue = (AttemptRequest.Stored)Preconditions.checkNotNull((Object)value, (Object)"stored");
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(newValue, this.workflowName, this.sessionTime, this.timeZone, this.sessionParams, this.sessionMonitors, this.retryAttemptName, this.resumingAttemptId, this.resumingTasks));
    }

    public final ImmutableAttemptRequest withWorkflowName(String value) {
        if (this.workflowName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"workflowName");
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, newValue, this.sessionTime, this.timeZone, this.sessionParams, this.sessionMonitors, this.retryAttemptName, this.resumingAttemptId, this.resumingTasks));
    }

    public final ImmutableAttemptRequest withSessionTime(Instant value) {
        if (this.sessionTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"sessionTime");
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, newValue, this.timeZone, this.sessionParams, this.sessionMonitors, this.retryAttemptName, this.resumingAttemptId, this.resumingTasks));
    }

    public final ImmutableAttemptRequest withTimeZone(ZoneId value) {
        if (this.timeZone == value) {
            return this;
        }
        ZoneId newValue = (ZoneId)Preconditions.checkNotNull((Object)value, (Object)"timeZone");
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, this.sessionTime, newValue, this.sessionParams, this.sessionMonitors, this.retryAttemptName, this.resumingAttemptId, this.resumingTasks));
    }

    public final ImmutableAttemptRequest withSessionParams(Config value) {
        if (this.sessionParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"sessionParams");
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, this.sessionTime, this.timeZone, newValue, this.sessionMonitors, this.retryAttemptName, this.resumingAttemptId, this.resumingTasks));
    }

    public final ImmutableAttemptRequest withSessionMonitors(SessionMonitor ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, this.sessionTime, this.timeZone, this.sessionParams, (ImmutableList<SessionMonitor>)newValue, this.retryAttemptName, this.resumingAttemptId, this.resumingTasks));
    }

    public final ImmutableAttemptRequest withSessionMonitors(Iterable<? extends SessionMonitor> elements) {
        if (this.sessionMonitors == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, this.sessionTime, this.timeZone, this.sessionParams, (ImmutableList<SessionMonitor>)newValue, this.retryAttemptName, this.resumingAttemptId, this.resumingTasks));
    }

    public final ImmutableAttemptRequest withRetryAttemptName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.retryAttemptName.equals((Object)newValue)) {
            return this;
        }
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, this.sessionTime, this.timeZone, this.sessionParams, this.sessionMonitors, (Optional<String>)newValue, this.resumingAttemptId, this.resumingTasks));
    }

    public final ImmutableAttemptRequest withRetryAttemptName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"retryAttemptName");
        if (this.retryAttemptName.equals((Object)value)) {
            return this;
        }
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, this.sessionTime, this.timeZone, this.sessionParams, this.sessionMonitors, (Optional<String>)value, this.resumingAttemptId, this.resumingTasks));
    }

    public final ImmutableAttemptRequest withResumingAttemptId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.resumingAttemptId.equals((Object)newValue)) {
            return this;
        }
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, this.sessionTime, this.timeZone, this.sessionParams, this.sessionMonitors, this.retryAttemptName, (Optional<Long>)newValue, this.resumingTasks));
    }

    public final ImmutableAttemptRequest withResumingAttemptId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"resumingAttemptId");
        if (this.resumingAttemptId.equals((Object)value)) {
            return this;
        }
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, this.sessionTime, this.timeZone, this.sessionParams, this.sessionMonitors, this.retryAttemptName, (Optional<Long>)value, this.resumingTasks));
    }

    public final ImmutableAttemptRequest withResumingTasks(long ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Longs.asList((long[])elements));
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, this.sessionTime, this.timeZone, this.sessionParams, this.sessionMonitors, this.retryAttemptName, this.resumingAttemptId, (ImmutableList<Long>)newValue));
    }

    public final ImmutableAttemptRequest withResumingTasks(Iterable<Long> elements) {
        if (this.resumingTasks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, this.sessionTime, this.timeZone, this.sessionParams, this.sessionMonitors, this.retryAttemptName, this.resumingAttemptId, (ImmutableList<Long>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAttemptRequest && this.equalTo((ImmutableAttemptRequest)another);
    }

    private boolean equalTo(ImmutableAttemptRequest another) {
        return this.stored.equals(another.stored) && this.workflowName.equals(another.workflowName) && this.sessionTime.equals(another.sessionTime) && this.timeZone.equals(another.timeZone) && this.sessionParams.equals((Object)another.sessionParams) && this.sessionMonitors.equals(another.sessionMonitors) && this.retryAttemptName.equals(another.retryAttemptName) && this.resumingAttemptId.equals(another.resumingAttemptId) && this.resumingTasks.equals(another.resumingTasks);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.stored.hashCode();
        h = h * 17 + this.workflowName.hashCode();
        h = h * 17 + this.sessionTime.hashCode();
        h = h * 17 + this.timeZone.hashCode();
        h = h * 17 + this.sessionParams.hashCode();
        h = h * 17 + this.sessionMonitors.hashCode();
        h = h * 17 + this.retryAttemptName.hashCode();
        h = h * 17 + this.resumingAttemptId.hashCode();
        h = h * 17 + this.resumingTasks.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AttemptRequest").omitNullValues().add("stored", (Object)this.stored).add("workflowName", (Object)this.workflowName).add("sessionTime", (Object)this.sessionTime).add("timeZone", (Object)this.timeZone).add("sessionParams", (Object)this.sessionParams).add("sessionMonitors", this.sessionMonitors).add("retryAttemptName", this.retryAttemptName.orNull()).add("resumingAttemptId", this.resumingAttemptId.orNull()).add("resumingTasks", this.resumingTasks).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAttemptRequest fromJson(Json json) {
        Builder builder = ImmutableAttemptRequest.builder();
        if (json.stored != null) {
            builder.stored(json.stored);
        }
        if (json.workflowName != null) {
            builder.workflowName(json.workflowName);
        }
        if (json.sessionTime != null) {
            builder.sessionTime(json.sessionTime);
        }
        if (json.timeZone != null) {
            builder.timeZone(json.timeZone);
        }
        if (json.sessionParams != null) {
            builder.sessionParams(json.sessionParams);
        }
        if (json.sessionMonitors != null) {
            builder.addAllSessionMonitors(json.sessionMonitors);
        }
        if (json.retryAttemptName != null) {
            builder.retryAttemptName(json.retryAttemptName);
        }
        if (json.resumingAttemptId != null) {
            builder.resumingAttemptId(json.resumingAttemptId);
        }
        if (json.resumingTasks != null) {
            builder.addAllResumingTasks(json.resumingTasks);
        }
        return builder.build();
    }

    private static ImmutableAttemptRequest validate(ImmutableAttemptRequest instance) {
        instance.check();
        return instance;
    }

    public static ImmutableAttemptRequest copyOf(AttemptRequest instance) {
        if (instance instanceof ImmutableAttemptRequest) {
            return (ImmutableAttemptRequest)instance;
        }
        return ImmutableAttemptRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STORED = 1L;
        private static final long INIT_BIT_WORKFLOW_NAME = 2L;
        private static final long INIT_BIT_SESSION_TIME = 4L;
        private static final long INIT_BIT_TIME_ZONE = 8L;
        private static final long INIT_BIT_SESSION_PARAMS = 16L;
        private long initBits = 31L;
        @Nullable
        private AttemptRequest.Stored stored;
        @Nullable
        private String workflowName;
        @Nullable
        private Instant sessionTime;
        @Nullable
        private ZoneId timeZone;
        @Nullable
        private Config sessionParams;
        private ImmutableList.Builder<SessionMonitor> sessionMonitors = ImmutableList.builder();
        private Optional<String> retryAttemptName = Optional.absent();
        private Optional<Long> resumingAttemptId = Optional.absent();
        private ImmutableList.Builder<Long> resumingTasks = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AttemptRequest instance) {
            Optional<Long> resumingAttemptIdOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.stored(instance.getStored());
            this.workflowName(instance.getWorkflowName());
            this.sessionTime(instance.getSessionTime());
            this.timeZone(instance.getTimeZone());
            this.sessionParams(instance.getSessionParams());
            this.addAllSessionMonitors(instance.getSessionMonitors());
            Optional<String> retryAttemptNameOptional = instance.getRetryAttemptName();
            if (retryAttemptNameOptional.isPresent()) {
                this.retryAttemptName(retryAttemptNameOptional);
            }
            if ((resumingAttemptIdOptional = instance.getResumingAttemptId()).isPresent()) {
                this.resumingAttemptId(resumingAttemptIdOptional);
            }
            this.addAllResumingTasks(instance.getResumingTasks());
            return this;
        }

        @JsonProperty(value="stored")
        @CanIgnoreReturnValue
        public final Builder stored(AttemptRequest.Stored stored) {
            this.stored = (AttemptRequest.Stored)Preconditions.checkNotNull((Object)stored, (Object)"stored");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="workflowName")
        @CanIgnoreReturnValue
        public final Builder workflowName(String workflowName) {
            this.workflowName = (String)Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="sessionTime")
        @CanIgnoreReturnValue
        public final Builder sessionTime(Instant sessionTime) {
            this.sessionTime = (Instant)Preconditions.checkNotNull((Object)sessionTime, (Object)"sessionTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="timeZone")
        @CanIgnoreReturnValue
        public final Builder timeZone(ZoneId timeZone) {
            this.timeZone = (ZoneId)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="sessionParams")
        @CanIgnoreReturnValue
        public final Builder sessionParams(Config sessionParams) {
            this.sessionParams = (Config)Preconditions.checkNotNull((Object)sessionParams, (Object)"sessionParams");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSessionMonitors(SessionMonitor element) {
            this.sessionMonitors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSessionMonitors(SessionMonitor ... elements) {
            this.sessionMonitors.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="sessionMonitors")
        @CanIgnoreReturnValue
        public final Builder sessionMonitors(Iterable<? extends SessionMonitor> elements) {
            this.sessionMonitors = ImmutableList.builder();
            return this.addAllSessionMonitors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSessionMonitors(Iterable<? extends SessionMonitor> elements) {
            this.sessionMonitors.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder retryAttemptName(String retryAttemptName) {
            this.retryAttemptName = Optional.of((Object)retryAttemptName);
            return this;
        }

        @JsonProperty(value="retryAttemptName")
        @CanIgnoreReturnValue
        public final Builder retryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = (Optional)Preconditions.checkNotNull(retryAttemptName, (Object)"retryAttemptName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder resumingAttemptId(long resumingAttemptId) {
            this.resumingAttemptId = Optional.of((Object)resumingAttemptId);
            return this;
        }

        @JsonProperty(value="resumingAttemptId")
        @CanIgnoreReturnValue
        public final Builder resumingAttemptId(Optional<Long> resumingAttemptId) {
            this.resumingAttemptId = (Optional)Preconditions.checkNotNull(resumingAttemptId, (Object)"resumingAttemptId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResumingTasks(long element) {
            this.resumingTasks.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResumingTasks(long ... elements) {
            this.resumingTasks.addAll((Iterable)Longs.asList((long[])elements));
            return this;
        }

        @JsonProperty(value="resumingTasks")
        @CanIgnoreReturnValue
        public final Builder resumingTasks(Iterable<Long> elements) {
            this.resumingTasks = ImmutableList.builder();
            return this.addAllResumingTasks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllResumingTasks(Iterable<Long> elements) {
            this.resumingTasks.addAll(elements);
            return this;
        }

        public ImmutableAttemptRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableAttemptRequest.validate(new ImmutableAttemptRequest(this.stored, this.workflowName, this.sessionTime, this.timeZone, this.sessionParams, this.sessionMonitors.build(), this.retryAttemptName, this.resumingAttemptId, this.resumingTasks.build()));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stored");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("workflowName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sessionTime");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("timeZone");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("sessionParams");
            }
            return "Cannot build AttemptRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AttemptRequest {
        @Nullable
        AttemptRequest.Stored stored;
        @Nullable
        String workflowName;
        @Nullable
        Instant sessionTime;
        @Nullable
        ZoneId timeZone;
        @Nullable
        Config sessionParams;
        List<SessionMonitor> sessionMonitors = ImmutableList.of();
        Optional<String> retryAttemptName = Optional.absent();
        Optional<Long> resumingAttemptId = Optional.absent();
        List<Long> resumingTasks = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="stored")
        public void setStored(AttemptRequest.Stored stored) {
            this.stored = stored;
        }

        @JsonProperty(value="workflowName")
        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @JsonProperty(value="sessionTime")
        public void setSessionTime(Instant sessionTime) {
            this.sessionTime = sessionTime;
        }

        @JsonProperty(value="timeZone")
        public void setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
        }

        @JsonProperty(value="sessionParams")
        public void setSessionParams(Config sessionParams) {
            this.sessionParams = sessionParams;
        }

        @JsonProperty(value="sessionMonitors")
        public void setSessionMonitors(List<SessionMonitor> sessionMonitors) {
            this.sessionMonitors = sessionMonitors;
        }

        @JsonProperty(value="retryAttemptName")
        public void setRetryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = retryAttemptName;
        }

        @JsonProperty(value="resumingAttemptId")
        public void setResumingAttemptId(Optional<Long> resumingAttemptId) {
            this.resumingAttemptId = resumingAttemptId;
        }

        @JsonProperty(value="resumingTasks")
        public void setResumingTasks(List<Long> resumingTasks) {
            this.resumingTasks = resumingTasks;
        }

        @Override
        public AttemptRequest.Stored getStored() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWorkflowName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getSessionTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZoneId getTimeZone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getSessionParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SessionMonitor> getSessionMonitors() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRetryAttemptName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getResumingAttemptId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Long> getResumingTasks() {
            throw new UnsupportedOperationException();
        }
    }
}

