/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;

public class TaskStateFlags {
    public static final int CANCEL_REQUESTED = 1;
    public static final int DELAYED_ERROR = 2;
    public static final int DELAYED_GROUP_ERROR = 4;
    public static final int INITIAL_TASK = 8;
    private final int flags;

    @JsonCreator
    public static TaskStateFlags of(int flags) {
        return new TaskStateFlags(flags);
    }

    public static TaskStateFlags empty() {
        return TaskStateFlags.of(0);
    }

    public TaskStateFlags(int flags) {
        Preconditions.checkArgument((flags >= 0 && flags < Short.MAX_VALUE ? 1 : 0) != 0, (Object)"TaskStateFlags must be positive 16-bit signed integer");
        int unknown = flags & 0xFFFFFFFE & 0xFFFFFFFD & 0xFFFFFFFB & 0xFFFFFFF7;
        Preconditions.checkArgument((unknown == 0 ? 1 : 0) != 0, (Object)"Unknown TaskStateFlags is set");
        this.flags = flags;
    }

    @JsonValue
    public int get() {
        return this.flags;
    }

    public TaskStateFlags withCancelRequested() {
        return TaskStateFlags.of(this.flags | 1);
    }

    public boolean isCancelRequested() {
        return (this.flags & 1) != 0;
    }

    public TaskStateFlags withDelayedError() {
        return TaskStateFlags.of(this.flags | 2);
    }

    public boolean isDelayedError() {
        return (this.flags & 2) != 0;
    }

    public TaskStateFlags withDelayedGroupError() {
        return TaskStateFlags.of(this.flags | 4);
    }

    public boolean isDelayedGroupError() {
        return (this.flags & 4) != 0;
    }

    public TaskStateFlags withInitialTask() {
        return TaskStateFlags.of(this.flags | 8);
    }

    public boolean isInitialTask() {
        return (this.flags & 8) != 0;
    }

    public int hashCode() {
        return this.flags;
    }

    public boolean equals(Object another) {
        return this == another || another instanceof TaskStateFlags && ((TaskStateFlags)another).flags == this.flags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.isCancelRequested()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("CANCEL_REQUESTED");
        }
        if (this.isDelayedError()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("DELAYED_ERROR");
        }
        if (this.isDelayedGroupError()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("DELAYED_GROUP_ERROR");
        }
        if (this.isInitialTask()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("INITIAL_TASK");
        }
        return "TaskStateFlags{" + sb.toString() + "}";
    }
}

