/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.session.TaskStateCode;
import io.digdag.core.session.TaskStateSummary;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableTaskStateSummary
extends TaskStateSummary {
    private final long id;
    private final Optional<Long> parentId;
    private final TaskStateCode state;
    private final Instant updatedAt;

    private ImmutableTaskStateSummary(long id, Optional<Long> parentId, TaskStateCode state, Instant updatedAt) {
        this.id = id;
        this.parentId = parentId;
        this.state = state;
        this.updatedAt = updatedAt;
    }

    @Override
    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="parentId")
    public Optional<Long> getParentId() {
        return this.parentId;
    }

    @Override
    @JsonProperty(value="state")
    public TaskStateCode getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public final ImmutableTaskStateSummary withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableTaskStateSummary(value, this.parentId, this.state, this.updatedAt);
    }

    public final ImmutableTaskStateSummary withParentId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.parentId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTaskStateSummary(this.id, (Optional<Long>)newValue, this.state, this.updatedAt);
    }

    public final ImmutableTaskStateSummary withParentId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"parentId");
        if (this.parentId.equals((Object)value)) {
            return this;
        }
        return new ImmutableTaskStateSummary(this.id, (Optional<Long>)value, this.state, this.updatedAt);
    }

    public final ImmutableTaskStateSummary withState(TaskStateCode value) {
        if (this.state == value) {
            return this;
        }
        TaskStateCode newValue = (TaskStateCode)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"state"));
        return new ImmutableTaskStateSummary(this.id, this.parentId, newValue, this.updatedAt);
    }

    public final ImmutableTaskStateSummary withUpdatedAt(Instant value) {
        if (this.updatedAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"updatedAt");
        return new ImmutableTaskStateSummary(this.id, this.parentId, this.state, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskStateSummary && this.equalTo((ImmutableTaskStateSummary)another);
    }

    private boolean equalTo(ImmutableTaskStateSummary another) {
        return this.id == another.id && this.parentId.equals(another.parentId) && this.state.equals((Object)another.state) && this.updatedAt.equals(another.updatedAt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.id);
        h = h * 17 + this.parentId.hashCode();
        h = h * 17 + this.state.hashCode();
        h = h * 17 + this.updatedAt.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaskStateSummary").omitNullValues().add("id", this.id).add("parentId", this.parentId.orNull()).add("state", (Object)this.state).add("updatedAt", (Object)this.updatedAt).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTaskStateSummary fromJson(Json json) {
        Builder builder = ImmutableTaskStateSummary.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.parentId != null) {
            builder.parentId(json.parentId);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        return builder.build();
    }

    public static ImmutableTaskStateSummary copyOf(TaskStateSummary instance) {
        if (instance instanceof ImmutableTaskStateSummary) {
            return (ImmutableTaskStateSummary)instance;
        }
        return ImmutableTaskStateSummary.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_STATE = 2L;
        private static final long INIT_BIT_UPDATED_AT = 4L;
        private long initBits = 7L;
        private long id;
        private Optional<Long> parentId = Optional.absent();
        @Nullable
        private TaskStateCode state;
        @Nullable
        private Instant updatedAt;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TaskStateSummary instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            Optional<Long> parentIdOptional = instance.getParentId();
            if (parentIdOptional.isPresent()) {
                this.parentId(parentIdOptional);
            }
            this.state(instance.getState());
            this.updatedAt(instance.getUpdatedAt());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentId(long parentId) {
            this.parentId = Optional.of((Object)parentId);
            return this;
        }

        @JsonProperty(value="parentId")
        @CanIgnoreReturnValue
        public final Builder parentId(Optional<Long> parentId) {
            this.parentId = (Optional)Preconditions.checkNotNull(parentId, (Object)"parentId");
            return this;
        }

        @JsonProperty(value="state")
        @CanIgnoreReturnValue
        public final Builder state(TaskStateCode state) {
            this.state = (TaskStateCode)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="updatedAt")
        @CanIgnoreReturnValue
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = (Instant)Preconditions.checkNotNull((Object)updatedAt, (Object)"updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTaskStateSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaskStateSummary(this.id, this.parentId, this.state, this.updatedAt);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("updatedAt");
            }
            return "Cannot build TaskStateSummary, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends TaskStateSummary {
        long id;
        boolean idIsSet;
        Optional<Long> parentId = Optional.absent();
        @Nullable
        TaskStateCode state;
        @Nullable
        Instant updatedAt;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="parentId")
        public void setParentId(Optional<Long> parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="state")
        public void setState(TaskStateCode state) {
            this.state = state;
        }

        @JsonProperty(value="updatedAt")
        public void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getParentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskStateCode getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getUpdatedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

