/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.session.TaskAttemptSummary;
import io.digdag.core.session.TaskStateCode;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableTaskAttemptSummary
extends TaskAttemptSummary {
    private final long id;
    private final long attemptId;
    private final TaskStateCode state;

    private ImmutableTaskAttemptSummary(long id, long attemptId, TaskStateCode state) {
        this.id = id;
        this.attemptId = attemptId;
        this.state = state;
    }

    @Override
    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="attemptId")
    public long getAttemptId() {
        return this.attemptId;
    }

    @Override
    @JsonProperty(value="state")
    public TaskStateCode getState() {
        return this.state;
    }

    public final ImmutableTaskAttemptSummary withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableTaskAttemptSummary(value, this.attemptId, this.state);
    }

    public final ImmutableTaskAttemptSummary withAttemptId(long value) {
        if (this.attemptId == value) {
            return this;
        }
        return new ImmutableTaskAttemptSummary(this.id, value, this.state);
    }

    public final ImmutableTaskAttemptSummary withState(TaskStateCode value) {
        if (this.state == value) {
            return this;
        }
        TaskStateCode newValue = (TaskStateCode)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"state"));
        return new ImmutableTaskAttemptSummary(this.id, this.attemptId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskAttemptSummary && this.equalTo((ImmutableTaskAttemptSummary)another);
    }

    private boolean equalTo(ImmutableTaskAttemptSummary another) {
        return this.id == another.id && this.attemptId == another.attemptId && this.state.equals((Object)another.state);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.id);
        h = h * 17 + Longs.hashCode((long)this.attemptId);
        h = h * 17 + this.state.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaskAttemptSummary").omitNullValues().add("id", this.id).add("attemptId", this.attemptId).add("state", (Object)this.state).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTaskAttemptSummary fromJson(Json json) {
        Builder builder = ImmutableTaskAttemptSummary.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.attemptIdIsSet) {
            builder.attemptId(json.attemptId);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        return builder.build();
    }

    public static ImmutableTaskAttemptSummary copyOf(TaskAttemptSummary instance) {
        if (instance instanceof ImmutableTaskAttemptSummary) {
            return (ImmutableTaskAttemptSummary)instance;
        }
        return ImmutableTaskAttemptSummary.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ATTEMPT_ID = 2L;
        private static final long INIT_BIT_STATE = 4L;
        private long initBits = 7L;
        private long id;
        private long attemptId;
        @Nullable
        private TaskStateCode state;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TaskAttemptSummary instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.attemptId(instance.getAttemptId());
            this.state(instance.getState());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="attemptId")
        @CanIgnoreReturnValue
        public final Builder attemptId(long attemptId) {
            this.attemptId = attemptId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="state")
        @CanIgnoreReturnValue
        public final Builder state(TaskStateCode state) {
            this.state = (TaskStateCode)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTaskAttemptSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaskAttemptSummary(this.id, this.attemptId, this.state);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("attemptId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("state");
            }
            return "Cannot build TaskAttemptSummary, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends TaskAttemptSummary {
        long id;
        boolean idIsSet;
        long attemptId;
        boolean attemptIdIsSet;
        @Nullable
        TaskStateCode state;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="attemptId")
        public void setAttemptId(long attemptId) {
            this.attemptId = attemptId;
            this.attemptIdIsSet = true;
        }

        @JsonProperty(value="state")
        public void setState(TaskStateCode state) {
            this.state = state;
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getAttemptId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskStateCode getState() {
            throw new UnsupportedOperationException();
        }
    }
}

