/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.session.Task;
import io.digdag.core.session.TaskImpl;
import io.digdag.core.session.TaskStateCode;
import io.digdag.core.session.TaskStateFlags;
import io.digdag.core.session.TaskType;
import io.digdag.core.workflow.TaskConfig;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableTask
extends TaskImpl {
    private final Optional<Long> parentId;
    private final String fullName;
    private final TaskConfig config;
    private final TaskType taskType;
    private final TaskStateCode state;
    private final TaskStateFlags stateFlags;

    private ImmutableTask(Optional<Long> parentId, String fullName, TaskConfig config, TaskType taskType, TaskStateCode state, TaskStateFlags stateFlags) {
        this.parentId = parentId;
        this.fullName = fullName;
        this.config = config;
        this.taskType = taskType;
        this.state = state;
        this.stateFlags = stateFlags;
    }

    @Override
    @JsonProperty(value="parentId")
    public Optional<Long> getParentId() {
        return this.parentId;
    }

    @Override
    @JsonProperty(value="fullName")
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @JsonProperty(value="config")
    public TaskConfig getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="taskType")
    public TaskType getTaskType() {
        return this.taskType;
    }

    @Override
    @JsonProperty(value="state")
    public TaskStateCode getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="stateFlags")
    public TaskStateFlags getStateFlags() {
        return this.stateFlags;
    }

    public final ImmutableTask withParentId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.parentId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTask((Optional<Long>)newValue, this.fullName, this.config, this.taskType, this.state, this.stateFlags);
    }

    public final ImmutableTask withParentId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"parentId");
        if (this.parentId.equals((Object)value)) {
            return this;
        }
        return new ImmutableTask((Optional<Long>)value, this.fullName, this.config, this.taskType, this.state, this.stateFlags);
    }

    public final ImmutableTask withFullName(String value) {
        if (this.fullName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"fullName");
        return new ImmutableTask(this.parentId, newValue, this.config, this.taskType, this.state, this.stateFlags);
    }

    public final ImmutableTask withConfig(TaskConfig value) {
        if (this.config == value) {
            return this;
        }
        TaskConfig newValue = (TaskConfig)Preconditions.checkNotNull((Object)value, (Object)"config");
        return new ImmutableTask(this.parentId, this.fullName, newValue, this.taskType, this.state, this.stateFlags);
    }

    public final ImmutableTask withTaskType(TaskType value) {
        if (this.taskType == value) {
            return this;
        }
        TaskType newValue = (TaskType)Preconditions.checkNotNull((Object)value, (Object)"taskType");
        return new ImmutableTask(this.parentId, this.fullName, this.config, newValue, this.state, this.stateFlags);
    }

    public final ImmutableTask withState(TaskStateCode value) {
        if (this.state == value) {
            return this;
        }
        TaskStateCode newValue = (TaskStateCode)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"state"));
        return new ImmutableTask(this.parentId, this.fullName, this.config, this.taskType, newValue, this.stateFlags);
    }

    public final ImmutableTask withStateFlags(TaskStateFlags value) {
        if (this.stateFlags == value) {
            return this;
        }
        TaskStateFlags newValue = (TaskStateFlags)Preconditions.checkNotNull((Object)value, (Object)"stateFlags");
        return new ImmutableTask(this.parentId, this.fullName, this.config, this.taskType, this.state, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTask && this.equalTo((ImmutableTask)another);
    }

    private boolean equalTo(ImmutableTask another) {
        return this.parentId.equals(another.parentId) && this.fullName.equals(another.fullName) && this.config.equals(another.config) && this.taskType.equals(another.taskType) && this.state.equals((Object)another.state) && this.stateFlags.equals(another.stateFlags);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.parentId.hashCode();
        h = h * 17 + this.fullName.hashCode();
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.taskType.hashCode();
        h = h * 17 + this.state.hashCode();
        h = h * 17 + this.stateFlags.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Task").omitNullValues().add("parentId", this.parentId.orNull()).add("fullName", (Object)this.fullName).add("config", (Object)this.config).add("taskType", (Object)this.taskType).add("state", (Object)this.state).add("stateFlags", (Object)this.stateFlags).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTask fromJson(Json json) {
        Builder builder = ImmutableTask.builder();
        if (json.parentId != null) {
            builder.parentId(json.parentId);
        }
        if (json.fullName != null) {
            builder.fullName(json.fullName);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.taskType != null) {
            builder.taskType(json.taskType);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.stateFlags != null) {
            builder.stateFlags(json.stateFlags);
        }
        return builder.build();
    }

    public static ImmutableTask copyOf(TaskImpl instance) {
        if (instance instanceof ImmutableTask) {
            return (ImmutableTask)instance;
        }
        return ImmutableTask.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FULL_NAME = 1L;
        private static final long INIT_BIT_CONFIG = 2L;
        private static final long INIT_BIT_TASK_TYPE = 4L;
        private static final long INIT_BIT_STATE = 8L;
        private static final long INIT_BIT_STATE_FLAGS = 16L;
        private long initBits = 31L;
        private Optional<Long> parentId = Optional.absent();
        @Nullable
        private String fullName;
        @Nullable
        private TaskConfig config;
        @Nullable
        private TaskType taskType;
        @Nullable
        private TaskStateCode state;
        @Nullable
        private TaskStateFlags stateFlags;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Task instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TaskImpl instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Task) {
                Task instance = (Task)object;
                this.fullName(instance.getFullName());
                this.taskType(instance.getTaskType());
                this.state(instance.getState());
                this.config(instance.getConfig());
                this.stateFlags(instance.getStateFlags());
                Optional<Long> parentIdOptional = instance.getParentId();
                if (parentIdOptional.isPresent()) {
                    this.parentId(parentIdOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder parentId(long parentId) {
            this.parentId = Optional.of((Object)parentId);
            return this;
        }

        @JsonProperty(value="parentId")
        @CanIgnoreReturnValue
        public final Builder parentId(Optional<Long> parentId) {
            this.parentId = (Optional)Preconditions.checkNotNull(parentId, (Object)"parentId");
            return this;
        }

        @JsonProperty(value="fullName")
        @CanIgnoreReturnValue
        public final Builder fullName(String fullName) {
            this.fullName = (String)Preconditions.checkNotNull((Object)fullName, (Object)"fullName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final Builder config(TaskConfig config) {
            this.config = (TaskConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="taskType")
        @CanIgnoreReturnValue
        public final Builder taskType(TaskType taskType) {
            this.taskType = (TaskType)Preconditions.checkNotNull((Object)taskType, (Object)"taskType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="state")
        @CanIgnoreReturnValue
        public final Builder state(TaskStateCode state) {
            this.state = (TaskStateCode)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="stateFlags")
        @CanIgnoreReturnValue
        public final Builder stateFlags(TaskStateFlags stateFlags) {
            this.stateFlags = (TaskStateFlags)Preconditions.checkNotNull((Object)stateFlags, (Object)"stateFlags");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableTask build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTask(this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fullName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("taskType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("stateFlags");
            }
            return "Cannot build Task, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends TaskImpl {
        Optional<Long> parentId = Optional.absent();
        @Nullable
        String fullName;
        @Nullable
        TaskConfig config;
        @Nullable
        TaskType taskType;
        @Nullable
        TaskStateCode state;
        @Nullable
        TaskStateFlags stateFlags;

        Json() {
        }

        @JsonProperty(value="parentId")
        public void setParentId(Optional<Long> parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="fullName")
        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        @JsonProperty(value="config")
        public void setConfig(TaskConfig config) {
            this.config = config;
        }

        @JsonProperty(value="taskType")
        public void setTaskType(TaskType taskType) {
            this.taskType = taskType;
        }

        @JsonProperty(value="state")
        public void setState(TaskStateCode state) {
            this.state = state;
        }

        @JsonProperty(value="stateFlags")
        public void setStateFlags(TaskStateFlags stateFlags) {
            this.stateFlags = stateFlags;
        }

        @Override
        public Optional<Long> getParentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFullName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskConfig getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskType getTaskType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskStateCode getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskStateFlags getStateFlags() {
            throw new UnsupportedOperationException();
        }
    }
}

