/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.session.Session;
import io.digdag.core.session.StoredSession;
import io.digdag.core.session.StoredSessionAttempt;
import io.digdag.core.session.StoredSessionWithLastAttempt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableStoredSessionWithLastAttempt
extends StoredSessionWithLastAttempt {
    private final int siteId;
    private final StoredSessionAttempt lastAttempt;
    private final long id;
    private final UUID uuid;
    private final long lastAttemptId;
    private final int projectId;
    private final String workflowName;
    private final Instant sessionTime;

    private ImmutableStoredSessionWithLastAttempt(int siteId, StoredSessionAttempt lastAttempt, long id, UUID uuid, long lastAttemptId, int projectId, String workflowName, Instant sessionTime) {
        this.siteId = siteId;
        this.lastAttempt = lastAttempt;
        this.id = id;
        this.uuid = uuid;
        this.lastAttemptId = lastAttemptId;
        this.projectId = projectId;
        this.workflowName = workflowName;
        this.sessionTime = sessionTime;
    }

    @Override
    @JsonProperty(value="siteId")
    public int getSiteId() {
        return this.siteId;
    }

    @Override
    @JsonProperty(value="lastAttempt")
    public StoredSessionAttempt getLastAttempt() {
        return this.lastAttempt;
    }

    @Override
    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="uuid")
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    @JsonProperty(value="lastAttemptId")
    public long getLastAttemptId() {
        return this.lastAttemptId;
    }

    @Override
    @JsonProperty(value="projectId")
    public int getProjectId() {
        return this.projectId;
    }

    @Override
    @JsonProperty(value="workflowName")
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Override
    @JsonProperty(value="sessionTime")
    public Instant getSessionTime() {
        return this.sessionTime;
    }

    public final ImmutableStoredSessionWithLastAttempt withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return new ImmutableStoredSessionWithLastAttempt(value, this.lastAttempt, this.id, this.uuid, this.lastAttemptId, this.projectId, this.workflowName, this.sessionTime);
    }

    public final ImmutableStoredSessionWithLastAttempt withLastAttempt(StoredSessionAttempt value) {
        if (this.lastAttempt == value) {
            return this;
        }
        StoredSessionAttempt newValue = (StoredSessionAttempt)Preconditions.checkNotNull((Object)value, (Object)"lastAttempt");
        return new ImmutableStoredSessionWithLastAttempt(this.siteId, newValue, this.id, this.uuid, this.lastAttemptId, this.projectId, this.workflowName, this.sessionTime);
    }

    public final ImmutableStoredSessionWithLastAttempt withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableStoredSessionWithLastAttempt(this.siteId, this.lastAttempt, value, this.uuid, this.lastAttemptId, this.projectId, this.workflowName, this.sessionTime);
    }

    public final ImmutableStoredSessionWithLastAttempt withUuid(UUID value) {
        if (this.uuid == value) {
            return this;
        }
        UUID newValue = (UUID)Preconditions.checkNotNull((Object)value, (Object)"uuid");
        return new ImmutableStoredSessionWithLastAttempt(this.siteId, this.lastAttempt, this.id, newValue, this.lastAttemptId, this.projectId, this.workflowName, this.sessionTime);
    }

    public final ImmutableStoredSessionWithLastAttempt withLastAttemptId(long value) {
        if (this.lastAttemptId == value) {
            return this;
        }
        return new ImmutableStoredSessionWithLastAttempt(this.siteId, this.lastAttempt, this.id, this.uuid, value, this.projectId, this.workflowName, this.sessionTime);
    }

    public final ImmutableStoredSessionWithLastAttempt withProjectId(int value) {
        if (this.projectId == value) {
            return this;
        }
        return new ImmutableStoredSessionWithLastAttempt(this.siteId, this.lastAttempt, this.id, this.uuid, this.lastAttemptId, value, this.workflowName, this.sessionTime);
    }

    public final ImmutableStoredSessionWithLastAttempt withWorkflowName(String value) {
        if (this.workflowName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"workflowName");
        return new ImmutableStoredSessionWithLastAttempt(this.siteId, this.lastAttempt, this.id, this.uuid, this.lastAttemptId, this.projectId, newValue, this.sessionTime);
    }

    public final ImmutableStoredSessionWithLastAttempt withSessionTime(Instant value) {
        if (this.sessionTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"sessionTime");
        return new ImmutableStoredSessionWithLastAttempt(this.siteId, this.lastAttempt, this.id, this.uuid, this.lastAttemptId, this.projectId, this.workflowName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredSessionWithLastAttempt && this.equalTo((ImmutableStoredSessionWithLastAttempt)another);
    }

    private boolean equalTo(ImmutableStoredSessionWithLastAttempt another) {
        return this.siteId == another.siteId && this.lastAttempt.equals(another.lastAttempt) && this.id == another.id && this.uuid.equals(another.uuid) && this.lastAttemptId == another.lastAttemptId && this.projectId == another.projectId && this.workflowName.equals(another.workflowName) && this.sessionTime.equals(another.sessionTime);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.siteId;
        h = h * 17 + this.lastAttempt.hashCode();
        h = h * 17 + Longs.hashCode((long)this.id);
        h = h * 17 + this.uuid.hashCode();
        h = h * 17 + Longs.hashCode((long)this.lastAttemptId);
        h = h * 17 + this.projectId;
        h = h * 17 + this.workflowName.hashCode();
        h = h * 17 + this.sessionTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredSessionWithLastAttempt").omitNullValues().add("siteId", this.siteId).add("lastAttempt", (Object)this.lastAttempt).add("id", this.id).add("uuid", (Object)this.uuid).add("lastAttemptId", this.lastAttemptId).add("projectId", this.projectId).add("workflowName", (Object)this.workflowName).add("sessionTime", (Object)this.sessionTime).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoredSessionWithLastAttempt fromJson(Json json) {
        Builder builder = ImmutableStoredSessionWithLastAttempt.builder();
        if (json.siteIdIsSet) {
            builder.siteId(json.siteId);
        }
        if (json.lastAttempt != null) {
            builder.lastAttempt(json.lastAttempt);
        }
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.uuid != null) {
            builder.uuid(json.uuid);
        }
        if (json.lastAttemptIdIsSet) {
            builder.lastAttemptId(json.lastAttemptId);
        }
        if (json.projectIdIsSet) {
            builder.projectId(json.projectId);
        }
        if (json.workflowName != null) {
            builder.workflowName(json.workflowName);
        }
        if (json.sessionTime != null) {
            builder.sessionTime(json.sessionTime);
        }
        return builder.build();
    }

    public static ImmutableStoredSessionWithLastAttempt copyOf(StoredSessionWithLastAttempt instance) {
        if (instance instanceof ImmutableStoredSessionWithLastAttempt) {
            return (ImmutableStoredSessionWithLastAttempt)instance;
        }
        return ImmutableStoredSessionWithLastAttempt.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SITE_ID = 1L;
        private static final long INIT_BIT_LAST_ATTEMPT = 2L;
        private static final long INIT_BIT_ID = 4L;
        private static final long INIT_BIT_UUID = 8L;
        private static final long INIT_BIT_LAST_ATTEMPT_ID = 16L;
        private static final long INIT_BIT_PROJECT_ID = 32L;
        private static final long INIT_BIT_WORKFLOW_NAME = 64L;
        private static final long INIT_BIT_SESSION_TIME = 128L;
        private long initBits = 255L;
        private int siteId;
        @Nullable
        private StoredSessionAttempt lastAttempt;
        private long id;
        @Nullable
        private UUID uuid;
        private long lastAttemptId;
        private int projectId;
        @Nullable
        private String workflowName;
        @Nullable
        private Instant sessionTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredSessionWithLastAttempt instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Session instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredSession instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Session instance;
            if (object instanceof StoredSessionWithLastAttempt) {
                instance = (StoredSessionWithLastAttempt)object;
                this.siteId(((StoredSessionWithLastAttempt)instance).getSiteId());
                this.lastAttempt(((StoredSessionWithLastAttempt)instance).getLastAttempt());
            }
            if (object instanceof Session) {
                instance = (Session)object;
                this.projectId(instance.getProjectId());
                this.workflowName(instance.getWorkflowName());
                this.sessionTime(instance.getSessionTime());
            }
            if (object instanceof StoredSession) {
                instance = (StoredSession)object;
                this.lastAttemptId(((StoredSession)instance).getLastAttemptId());
                this.uuid(((StoredSession)instance).getUuid());
                this.id(((StoredSession)instance).getId());
            }
        }

        @JsonProperty(value="siteId")
        @CanIgnoreReturnValue
        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="lastAttempt")
        @CanIgnoreReturnValue
        public final Builder lastAttempt(StoredSessionAttempt lastAttempt) {
            this.lastAttempt = (StoredSessionAttempt)Preconditions.checkNotNull((Object)lastAttempt, (Object)"lastAttempt");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="uuid")
        @CanIgnoreReturnValue
        public final Builder uuid(UUID uuid) {
            this.uuid = (UUID)Preconditions.checkNotNull((Object)uuid, (Object)"uuid");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="lastAttemptId")
        @CanIgnoreReturnValue
        public final Builder lastAttemptId(long lastAttemptId) {
            this.lastAttemptId = lastAttemptId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="projectId")
        @CanIgnoreReturnValue
        public final Builder projectId(int projectId) {
            this.projectId = projectId;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="workflowName")
        @CanIgnoreReturnValue
        public final Builder workflowName(String workflowName) {
            this.workflowName = (String)Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="sessionTime")
        @CanIgnoreReturnValue
        public final Builder sessionTime(Instant sessionTime) {
            this.sessionTime = (Instant)Preconditions.checkNotNull((Object)sessionTime, (Object)"sessionTime");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableStoredSessionWithLastAttempt build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStoredSessionWithLastAttempt(this.siteId, this.lastAttempt, this.id, this.uuid, this.lastAttemptId, this.projectId, this.workflowName, this.sessionTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("lastAttempt");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("uuid");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("lastAttemptId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("projectId");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("workflowName");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("sessionTime");
            }
            return "Cannot build StoredSessionWithLastAttempt, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends StoredSessionWithLastAttempt {
        int siteId;
        boolean siteIdIsSet;
        @Nullable
        StoredSessionAttempt lastAttempt;
        long id;
        boolean idIsSet;
        @Nullable
        UUID uuid;
        long lastAttemptId;
        boolean lastAttemptIdIsSet;
        int projectId;
        boolean projectIdIsSet;
        @Nullable
        String workflowName;
        @Nullable
        Instant sessionTime;

        Json() {
        }

        @JsonProperty(value="siteId")
        public void setSiteId(int siteId) {
            this.siteId = siteId;
            this.siteIdIsSet = true;
        }

        @JsonProperty(value="lastAttempt")
        public void setLastAttempt(StoredSessionAttempt lastAttempt) {
            this.lastAttempt = lastAttempt;
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="uuid")
        public void setUuid(UUID uuid) {
            this.uuid = uuid;
        }

        @JsonProperty(value="lastAttemptId")
        public void setLastAttemptId(long lastAttemptId) {
            this.lastAttemptId = lastAttemptId;
            this.lastAttemptIdIsSet = true;
        }

        @JsonProperty(value="projectId")
        public void setProjectId(int projectId) {
            this.projectId = projectId;
            this.projectIdIsSet = true;
        }

        @JsonProperty(value="workflowName")
        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @JsonProperty(value="sessionTime")
        public void setSessionTime(Instant sessionTime) {
            this.sessionTime = sessionTime;
        }

        @Override
        public int getSiteId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StoredSessionAttempt getLastAttempt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UUID getUuid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastAttemptId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProjectId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWorkflowName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getSessionTime() {
            throw new UnsupportedOperationException();
        }
    }
}

