/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.session.SessionMonitor;
import io.digdag.core.session.SessionMonitorImpl;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableSessionMonitor
extends SessionMonitorImpl {
    private final String type;
    private final Config config;
    private final Instant nextRunTime;

    private ImmutableSessionMonitor(String type, Config config, Instant nextRunTime) {
        this.type = type;
        this.config = config;
        this.nextRunTime = nextRunTime;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="config")
    public Config getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="nextRunTime")
    public Instant getNextRunTime() {
        return this.nextRunTime;
    }

    public final ImmutableSessionMonitor withType(String value) {
        if (this.type.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"type");
        return new ImmutableSessionMonitor(newValue, this.config, this.nextRunTime);
    }

    public final ImmutableSessionMonitor withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"config");
        return new ImmutableSessionMonitor(this.type, newValue, this.nextRunTime);
    }

    public final ImmutableSessionMonitor withNextRunTime(Instant value) {
        if (this.nextRunTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"nextRunTime");
        return new ImmutableSessionMonitor(this.type, this.config, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSessionMonitor && this.equalTo((ImmutableSessionMonitor)another);
    }

    private boolean equalTo(ImmutableSessionMonitor another) {
        return this.type.equals(another.type) && this.config.equals((Object)another.config) && this.nextRunTime.equals(another.nextRunTime);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.nextRunTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SessionMonitor").omitNullValues().add("type", (Object)this.type).add("config", (Object)this.config).add("nextRunTime", (Object)this.nextRunTime).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSessionMonitor fromJson(Json json) {
        Builder builder = ImmutableSessionMonitor.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.nextRunTime != null) {
            builder.nextRunTime(json.nextRunTime);
        }
        return builder.build();
    }

    public static ImmutableSessionMonitor copyOf(SessionMonitorImpl instance) {
        if (instance instanceof ImmutableSessionMonitor) {
            return (ImmutableSessionMonitor)instance;
        }
        return ImmutableSessionMonitor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CONFIG = 2L;
        private static final long INIT_BIT_NEXT_RUN_TIME = 4L;
        private long initBits = 7L;
        @Nullable
        private String type;
        @Nullable
        private Config config;
        @Nullable
        private Instant nextRunTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SessionMonitor instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(SessionMonitorImpl instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof SessionMonitor) {
                SessionMonitor instance = (SessionMonitor)object;
                this.type(instance.getType());
                this.config(instance.getConfig());
                this.nextRunTime(instance.getNextRunTime());
            }
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final Builder config(Config config) {
            this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="nextRunTime")
        @CanIgnoreReturnValue
        public final Builder nextRunTime(Instant nextRunTime) {
            this.nextRunTime = (Instant)Preconditions.checkNotNull((Object)nextRunTime, (Object)"nextRunTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSessionMonitor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSessionMonitor(this.type, this.config, this.nextRunTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("nextRunTime");
            }
            return "Cannot build SessionMonitor, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends SessionMonitorImpl {
        @Nullable
        String type;
        @Nullable
        Config config;
        @Nullable
        Instant nextRunTime;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @JsonProperty(value="nextRunTime")
        public void setNextRunTime(Instant nextRunTime) {
            this.nextRunTime = nextRunTime;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getNextRunTime() {
            throw new UnsupportedOperationException();
        }
    }
}

