/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigKey;
import io.digdag.core.session.ArchivedTask;
import io.digdag.core.session.StoredTask;
import io.digdag.core.session.Task;
import io.digdag.core.session.TaskStateCode;
import io.digdag.core.session.TaskStateFlags;
import io.digdag.core.session.TaskType;
import io.digdag.core.workflow.TaskConfig;
import io.digdag.spi.TaskReport;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableArchivedTask
extends ArchivedTask {
    private final Config subtaskConfig;
    private final Config exportParams;
    private final ImmutableList<ConfigKey> resetStoreParams;
    private final Config storeParams;
    private final Optional<TaskReport> report;
    private final Config error;
    private final Optional<Long> resumingTaskId;
    private final long id;
    private final long attemptId;
    private final ImmutableList<Long> upstreams;
    private final Instant updatedAt;
    private final Optional<Instant> retryAt;
    private final Optional<Instant> startedAt;
    private final Config stateParams;
    private final int retryCount;
    private final Optional<Long> parentId;
    private final String fullName;
    private final TaskConfig config;
    private final TaskType taskType;
    private final TaskStateCode state;
    private final TaskStateFlags stateFlags;

    private ImmutableArchivedTask(Builder builder) {
        this.subtaskConfig = builder.subtaskConfig;
        this.exportParams = builder.exportParams;
        this.resetStoreParams = builder.resetStoreParams.build();
        this.storeParams = builder.storeParams;
        this.report = builder.report;
        this.error = builder.error;
        this.resumingTaskId = builder.resumingTaskId;
        this.id = builder.id;
        this.attemptId = builder.attemptId;
        this.upstreams = builder.upstreams.build();
        this.updatedAt = builder.updatedAt;
        this.retryAt = builder.retryAt;
        this.startedAt = builder.startedAt;
        this.stateParams = builder.stateParams;
        this.parentId = builder.parentId;
        this.fullName = builder.fullName;
        this.config = builder.config;
        this.taskType = builder.taskType;
        this.state = builder.state;
        this.stateFlags = builder.stateFlags;
        this.retryCount = builder.retryCountIsSet() ? builder.retryCount : super.getRetryCount();
    }

    private ImmutableArchivedTask(Config subtaskConfig, Config exportParams, ImmutableList<ConfigKey> resetStoreParams, Config storeParams, Optional<TaskReport> report, Config error, Optional<Long> resumingTaskId, long id, long attemptId, ImmutableList<Long> upstreams, Instant updatedAt, Optional<Instant> retryAt, Optional<Instant> startedAt, Config stateParams, int retryCount, Optional<Long> parentId, String fullName, TaskConfig config, TaskType taskType, TaskStateCode state, TaskStateFlags stateFlags) {
        this.subtaskConfig = subtaskConfig;
        this.exportParams = exportParams;
        this.resetStoreParams = resetStoreParams;
        this.storeParams = storeParams;
        this.report = report;
        this.error = error;
        this.resumingTaskId = resumingTaskId;
        this.id = id;
        this.attemptId = attemptId;
        this.upstreams = upstreams;
        this.updatedAt = updatedAt;
        this.retryAt = retryAt;
        this.startedAt = startedAt;
        this.stateParams = stateParams;
        this.retryCount = retryCount;
        this.parentId = parentId;
        this.fullName = fullName;
        this.config = config;
        this.taskType = taskType;
        this.state = state;
        this.stateFlags = stateFlags;
    }

    @Override
    @JsonProperty(value="subtaskConfig")
    public Config getSubtaskConfig() {
        return this.subtaskConfig;
    }

    @Override
    @JsonProperty(value="exportParams")
    public Config getExportParams() {
        return this.exportParams;
    }

    @JsonProperty(value="resetStoreParams")
    public ImmutableList<ConfigKey> getResetStoreParams() {
        return this.resetStoreParams;
    }

    @Override
    @JsonProperty(value="storeParams")
    public Config getStoreParams() {
        return this.storeParams;
    }

    @Override
    @JsonProperty(value="report")
    public Optional<TaskReport> getReport() {
        return this.report;
    }

    @Override
    @JsonProperty(value="error")
    public Config getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="resumingTaskId")
    public Optional<Long> getResumingTaskId() {
        return this.resumingTaskId;
    }

    @Override
    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="attemptId")
    public long getAttemptId() {
        return this.attemptId;
    }

    @JsonProperty(value="upstreams")
    public ImmutableList<Long> getUpstreams() {
        return this.upstreams;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="retryAt")
    public Optional<Instant> getRetryAt() {
        return this.retryAt;
    }

    @Override
    @JsonProperty(value="startedAt")
    public Optional<Instant> getStartedAt() {
        return this.startedAt;
    }

    @Override
    @JsonProperty(value="stateParams")
    public Config getStateParams() {
        return this.stateParams;
    }

    @Override
    @JsonProperty(value="retryCount")
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    @JsonProperty(value="parentId")
    public Optional<Long> getParentId() {
        return this.parentId;
    }

    @Override
    @JsonProperty(value="fullName")
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @JsonProperty(value="config")
    public TaskConfig getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="taskType")
    public TaskType getTaskType() {
        return this.taskType;
    }

    @Override
    @JsonProperty(value="state")
    public TaskStateCode getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="stateFlags")
    public TaskStateFlags getStateFlags() {
        return this.stateFlags;
    }

    public final ImmutableArchivedTask withSubtaskConfig(Config value) {
        if (this.subtaskConfig == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"subtaskConfig");
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(newValue, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withExportParams(Config value) {
        if (this.exportParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"exportParams");
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, newValue, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withResetStoreParams(ConfigKey ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, (ImmutableList<ConfigKey>)newValue, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withResetStoreParams(Iterable<? extends ConfigKey> elements) {
        if (this.resetStoreParams == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, (ImmutableList<ConfigKey>)newValue, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withStoreParams(Config value) {
        if (this.storeParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"storeParams");
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, newValue, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withReport(TaskReport value) {
        Optional newValue = Optional.of((Object)value);
        if (this.report.isPresent() && this.report.get() == value) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, (Optional<TaskReport>)newValue, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withReport(Optional<TaskReport> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"report");
        if (!this.report.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.report.isPresent() && value.isPresent() && this.report.get() == value.get()) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, (Optional<TaskReport>)value, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withError(Config value) {
        if (this.error == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"error");
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, newValue, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withResumingTaskId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.resumingTaskId.equals((Object)newValue)) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, (Optional<Long>)newValue, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withResumingTaskId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"resumingTaskId");
        if (this.resumingTaskId.equals((Object)value)) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, (Optional<Long>)value, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withId(long value) {
        if (this.id == value) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, value, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withAttemptId(long value) {
        if (this.attemptId == value) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, value, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withUpstreams(long ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Longs.asList((long[])elements));
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, (ImmutableList<Long>)newValue, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withUpstreams(Iterable<Long> elements) {
        if (this.upstreams == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, (ImmutableList<Long>)newValue, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withUpdatedAt(Instant value) {
        if (this.updatedAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"updatedAt");
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, newValue, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withRetryAt(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.retryAt.isPresent() && this.retryAt.get() == value) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, (Optional<Instant>)newValue, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withRetryAt(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"retryAt");
        if (!this.retryAt.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.retryAt.isPresent() && value.isPresent() && this.retryAt.get() == value.get()) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, (Optional<Instant>)value, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withStartedAt(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.startedAt.isPresent() && this.startedAt.get() == value) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, (Optional<Instant>)newValue, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withStartedAt(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"startedAt");
        if (!this.startedAt.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.startedAt.isPresent() && value.isPresent() && this.startedAt.get() == value.get()) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, (Optional<Instant>)value, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withStateParams(Config value) {
        if (this.stateParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"stateParams");
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, newValue, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withRetryCount(int value) {
        if (this.retryCount == value) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, value, this.parentId, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withParentId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.parentId.equals((Object)newValue)) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, (Optional<Long>)newValue, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withParentId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"parentId");
        if (this.parentId.equals((Object)value)) {
            return this;
        }
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, (Optional<Long>)value, this.fullName, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withFullName(String value) {
        if (this.fullName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"fullName");
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, newValue, this.config, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withConfig(TaskConfig value) {
        if (this.config == value) {
            return this;
        }
        TaskConfig newValue = (TaskConfig)Preconditions.checkNotNull((Object)value, (Object)"config");
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, newValue, this.taskType, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withTaskType(TaskType value) {
        if (this.taskType == value) {
            return this;
        }
        TaskType newValue = (TaskType)Preconditions.checkNotNull((Object)value, (Object)"taskType");
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, newValue, this.state, this.stateFlags));
    }

    public final ImmutableArchivedTask withState(TaskStateCode value) {
        if (this.state == value) {
            return this;
        }
        TaskStateCode newValue = (TaskStateCode)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"state"));
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, newValue, this.stateFlags));
    }

    public final ImmutableArchivedTask withStateFlags(TaskStateFlags value) {
        if (this.stateFlags == value) {
            return this;
        }
        TaskStateFlags newValue = (TaskStateFlags)Preconditions.checkNotNull((Object)value, (Object)"stateFlags");
        return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error, this.resumingTaskId, this.id, this.attemptId, this.upstreams, this.updatedAt, this.retryAt, this.startedAt, this.stateParams, this.retryCount, this.parentId, this.fullName, this.config, this.taskType, this.state, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableArchivedTask && this.equalTo((ImmutableArchivedTask)another);
    }

    private boolean equalTo(ImmutableArchivedTask another) {
        return this.subtaskConfig.equals((Object)another.subtaskConfig) && this.exportParams.equals((Object)another.exportParams) && this.resetStoreParams.equals(another.resetStoreParams) && this.storeParams.equals((Object)another.storeParams) && this.report.equals(another.report) && this.error.equals((Object)another.error) && this.resumingTaskId.equals(another.resumingTaskId) && this.id == another.id && this.attemptId == another.attemptId && this.upstreams.equals(another.upstreams) && this.updatedAt.equals(another.updatedAt) && this.retryAt.equals(another.retryAt) && this.startedAt.equals(another.startedAt) && this.stateParams.equals((Object)another.stateParams) && this.retryCount == another.retryCount && this.parentId.equals(another.parentId) && this.fullName.equals(another.fullName) && this.config.equals(another.config) && this.taskType.equals(another.taskType) && this.state.equals((Object)another.state) && this.stateFlags.equals(another.stateFlags);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.subtaskConfig.hashCode();
        h = h * 17 + this.exportParams.hashCode();
        h = h * 17 + this.resetStoreParams.hashCode();
        h = h * 17 + this.storeParams.hashCode();
        h = h * 17 + this.report.hashCode();
        h = h * 17 + this.error.hashCode();
        h = h * 17 + this.resumingTaskId.hashCode();
        h = h * 17 + Longs.hashCode((long)this.id);
        h = h * 17 + Longs.hashCode((long)this.attemptId);
        h = h * 17 + this.upstreams.hashCode();
        h = h * 17 + this.updatedAt.hashCode();
        h = h * 17 + this.retryAt.hashCode();
        h = h * 17 + this.startedAt.hashCode();
        h = h * 17 + this.stateParams.hashCode();
        h = h * 17 + this.retryCount;
        h = h * 17 + this.parentId.hashCode();
        h = h * 17 + this.fullName.hashCode();
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.taskType.hashCode();
        h = h * 17 + this.state.hashCode();
        h = h * 17 + this.stateFlags.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ArchivedTask").omitNullValues().add("subtaskConfig", (Object)this.subtaskConfig).add("exportParams", (Object)this.exportParams).add("resetStoreParams", this.resetStoreParams).add("storeParams", (Object)this.storeParams).add("report", this.report.orNull()).add("error", (Object)this.error).add("resumingTaskId", this.resumingTaskId.orNull()).add("id", this.id).add("attemptId", this.attemptId).add("upstreams", this.upstreams).add("updatedAt", (Object)this.updatedAt).add("retryAt", this.retryAt.orNull()).add("startedAt", this.startedAt.orNull()).add("stateParams", (Object)this.stateParams).add("retryCount", this.retryCount).add("parentId", this.parentId.orNull()).add("fullName", (Object)this.fullName).add("config", (Object)this.config).add("taskType", (Object)this.taskType).add("state", (Object)this.state).add("stateFlags", (Object)this.stateFlags).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableArchivedTask fromJson(Json json) {
        Builder builder = ImmutableArchivedTask.builder();
        if (json.subtaskConfig != null) {
            builder.subtaskConfig(json.subtaskConfig);
        }
        if (json.exportParams != null) {
            builder.exportParams(json.exportParams);
        }
        if (json.resetStoreParams != null) {
            builder.addAllResetStoreParams(json.resetStoreParams);
        }
        if (json.storeParams != null) {
            builder.storeParams(json.storeParams);
        }
        if (json.report != null) {
            builder.report(json.report);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.resumingTaskId != null) {
            builder.resumingTaskId(json.resumingTaskId);
        }
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.attemptIdIsSet) {
            builder.attemptId(json.attemptId);
        }
        if (json.upstreams != null) {
            builder.addAllUpstreams(json.upstreams);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.retryAt != null) {
            builder.retryAt(json.retryAt);
        }
        if (json.startedAt != null) {
            builder.startedAt(json.startedAt);
        }
        if (json.stateParams != null) {
            builder.stateParams(json.stateParams);
        }
        if (json.retryCountIsSet) {
            builder.retryCount(json.retryCount);
        }
        if (json.parentId != null) {
            builder.parentId(json.parentId);
        }
        if (json.fullName != null) {
            builder.fullName(json.fullName);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.taskType != null) {
            builder.taskType(json.taskType);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.stateFlags != null) {
            builder.stateFlags(json.stateFlags);
        }
        return builder.build();
    }

    private static ImmutableArchivedTask validate(ImmutableArchivedTask instance) {
        instance.check();
        return instance;
    }

    public static ImmutableArchivedTask copyOf(ArchivedTask instance) {
        if (instance instanceof ImmutableArchivedTask) {
            return (ImmutableArchivedTask)instance;
        }
        return ImmutableArchivedTask.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SUBTASK_CONFIG = 1L;
        private static final long INIT_BIT_EXPORT_PARAMS = 2L;
        private static final long INIT_BIT_STORE_PARAMS = 4L;
        private static final long INIT_BIT_ERROR = 8L;
        private static final long INIT_BIT_ID = 16L;
        private static final long INIT_BIT_ATTEMPT_ID = 32L;
        private static final long INIT_BIT_UPDATED_AT = 64L;
        private static final long INIT_BIT_STATE_PARAMS = 128L;
        private static final long INIT_BIT_FULL_NAME = 256L;
        private static final long INIT_BIT_CONFIG = 512L;
        private static final long INIT_BIT_TASK_TYPE = 1024L;
        private static final long INIT_BIT_STATE = 2048L;
        private static final long INIT_BIT_STATE_FLAGS = 4096L;
        private static final long OPT_BIT_RETRY_COUNT = 1L;
        private long initBits = 8191L;
        private long optBits;
        @Nullable
        private Config subtaskConfig;
        @Nullable
        private Config exportParams;
        private ImmutableList.Builder<ConfigKey> resetStoreParams = ImmutableList.builder();
        @Nullable
        private Config storeParams;
        private Optional<TaskReport> report = Optional.absent();
        @Nullable
        private Config error;
        private Optional<Long> resumingTaskId = Optional.absent();
        private long id;
        private long attemptId;
        private ImmutableList.Builder<Long> upstreams = ImmutableList.builder();
        @Nullable
        private Instant updatedAt;
        private Optional<Instant> retryAt = Optional.absent();
        private Optional<Instant> startedAt = Optional.absent();
        @Nullable
        private Config stateParams;
        private int retryCount;
        private Optional<Long> parentId = Optional.absent();
        @Nullable
        private String fullName;
        @Nullable
        private TaskConfig config;
        @Nullable
        private TaskType taskType;
        @Nullable
        private TaskStateCode state;
        @Nullable
        private TaskStateFlags stateFlags;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ArchivedTask instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Task instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredTask instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Task instance;
            if (object instanceof ArchivedTask) {
                instance = (ArchivedTask)object;
                this.subtaskConfig(((ArchivedTask)instance).getSubtaskConfig());
                this.addAllResetStoreParams(((ArchivedTask)instance).getResetStoreParams());
                Optional<TaskReport> reportOptional = ((ArchivedTask)instance).getReport();
                if (reportOptional.isPresent()) {
                    this.report(reportOptional);
                }
                this.exportParams(((ArchivedTask)instance).getExportParams());
                this.error(((ArchivedTask)instance).getError());
                Optional<Long> resumingTaskIdOptional = ((ArchivedTask)instance).getResumingTaskId();
                if (resumingTaskIdOptional.isPresent()) {
                    this.resumingTaskId(resumingTaskIdOptional);
                }
                this.storeParams(((ArchivedTask)instance).getStoreParams());
            }
            if (object instanceof Task) {
                instance = (Task)object;
                this.fullName(instance.getFullName());
                this.taskType(instance.getTaskType());
                this.state(instance.getState());
                this.config(instance.getConfig());
                this.stateFlags(instance.getStateFlags());
                Optional<Long> parentIdOptional = instance.getParentId();
                if (parentIdOptional.isPresent()) {
                    this.parentId(parentIdOptional);
                }
            }
            if (object instanceof StoredTask) {
                instance = (StoredTask)object;
                Optional<Instant> retryAtOptional = ((StoredTask)instance).getRetryAt();
                if (retryAtOptional.isPresent()) {
                    this.retryAt(retryAtOptional);
                }
                this.addAllUpstreams(((StoredTask)instance).getUpstreams());
                this.retryCount(((StoredTask)instance).getRetryCount());
                this.stateParams(((StoredTask)instance).getStateParams());
                Optional<Instant> startedAtOptional = ((StoredTask)instance).getStartedAt();
                if (startedAtOptional.isPresent()) {
                    this.startedAt(startedAtOptional);
                }
                this.id(((StoredTask)instance).getId());
                this.attemptId(((StoredTask)instance).getAttemptId());
                this.updatedAt(((StoredTask)instance).getUpdatedAt());
            }
        }

        @JsonProperty(value="subtaskConfig")
        @CanIgnoreReturnValue
        public final Builder subtaskConfig(Config subtaskConfig) {
            this.subtaskConfig = (Config)Preconditions.checkNotNull((Object)subtaskConfig, (Object)"subtaskConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="exportParams")
        @CanIgnoreReturnValue
        public final Builder exportParams(Config exportParams) {
            this.exportParams = (Config)Preconditions.checkNotNull((Object)exportParams, (Object)"exportParams");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResetStoreParams(ConfigKey element) {
            this.resetStoreParams.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResetStoreParams(ConfigKey ... elements) {
            this.resetStoreParams.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="resetStoreParams")
        @CanIgnoreReturnValue
        public final Builder resetStoreParams(Iterable<? extends ConfigKey> elements) {
            this.resetStoreParams = ImmutableList.builder();
            return this.addAllResetStoreParams(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllResetStoreParams(Iterable<? extends ConfigKey> elements) {
            this.resetStoreParams.addAll(elements);
            return this;
        }

        @JsonProperty(value="storeParams")
        @CanIgnoreReturnValue
        public final Builder storeParams(Config storeParams) {
            this.storeParams = (Config)Preconditions.checkNotNull((Object)storeParams, (Object)"storeParams");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder report(TaskReport report) {
            this.report = Optional.of((Object)report);
            return this;
        }

        @JsonProperty(value="report")
        @CanIgnoreReturnValue
        public final Builder report(Optional<TaskReport> report) {
            this.report = (Optional)Preconditions.checkNotNull(report, (Object)"report");
            return this;
        }

        @JsonProperty(value="error")
        @CanIgnoreReturnValue
        public final Builder error(Config error) {
            this.error = (Config)Preconditions.checkNotNull((Object)error, (Object)"error");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder resumingTaskId(long resumingTaskId) {
            this.resumingTaskId = Optional.of((Object)resumingTaskId);
            return this;
        }

        @JsonProperty(value="resumingTaskId")
        @CanIgnoreReturnValue
        public final Builder resumingTaskId(Optional<Long> resumingTaskId) {
            this.resumingTaskId = (Optional)Preconditions.checkNotNull(resumingTaskId, (Object)"resumingTaskId");
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="attemptId")
        @CanIgnoreReturnValue
        public final Builder attemptId(long attemptId) {
            this.attemptId = attemptId;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUpstreams(long element) {
            this.upstreams.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUpstreams(long ... elements) {
            this.upstreams.addAll((Iterable)Longs.asList((long[])elements));
            return this;
        }

        @JsonProperty(value="upstreams")
        @CanIgnoreReturnValue
        public final Builder upstreams(Iterable<Long> elements) {
            this.upstreams = ImmutableList.builder();
            return this.addAllUpstreams(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllUpstreams(Iterable<Long> elements) {
            this.upstreams.addAll(elements);
            return this;
        }

        @JsonProperty(value="updatedAt")
        @CanIgnoreReturnValue
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = (Instant)Preconditions.checkNotNull((Object)updatedAt, (Object)"updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder retryAt(Instant retryAt) {
            this.retryAt = Optional.of((Object)retryAt);
            return this;
        }

        @JsonProperty(value="retryAt")
        @CanIgnoreReturnValue
        public final Builder retryAt(Optional<Instant> retryAt) {
            this.retryAt = (Optional)Preconditions.checkNotNull(retryAt, (Object)"retryAt");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = Optional.of((Object)startedAt);
            return this;
        }

        @JsonProperty(value="startedAt")
        @CanIgnoreReturnValue
        public final Builder startedAt(Optional<Instant> startedAt) {
            this.startedAt = (Optional)Preconditions.checkNotNull(startedAt, (Object)"startedAt");
            return this;
        }

        @JsonProperty(value="stateParams")
        @CanIgnoreReturnValue
        public final Builder stateParams(Config stateParams) {
            this.stateParams = (Config)Preconditions.checkNotNull((Object)stateParams, (Object)"stateParams");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="retryCount")
        @CanIgnoreReturnValue
        public final Builder retryCount(int retryCount) {
            this.retryCount = retryCount;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentId(long parentId) {
            this.parentId = Optional.of((Object)parentId);
            return this;
        }

        @JsonProperty(value="parentId")
        @CanIgnoreReturnValue
        public final Builder parentId(Optional<Long> parentId) {
            this.parentId = (Optional)Preconditions.checkNotNull(parentId, (Object)"parentId");
            return this;
        }

        @JsonProperty(value="fullName")
        @CanIgnoreReturnValue
        public final Builder fullName(String fullName) {
            this.fullName = (String)Preconditions.checkNotNull((Object)fullName, (Object)"fullName");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final Builder config(TaskConfig config) {
            this.config = (TaskConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty(value="taskType")
        @CanIgnoreReturnValue
        public final Builder taskType(TaskType taskType) {
            this.taskType = (TaskType)Preconditions.checkNotNull((Object)taskType, (Object)"taskType");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @JsonProperty(value="state")
        @CanIgnoreReturnValue
        public final Builder state(TaskStateCode state) {
            this.state = (TaskStateCode)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @JsonProperty(value="stateFlags")
        @CanIgnoreReturnValue
        public final Builder stateFlags(TaskStateFlags stateFlags) {
            this.stateFlags = (TaskStateFlags)Preconditions.checkNotNull((Object)stateFlags, (Object)"stateFlags");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public ImmutableArchivedTask build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableArchivedTask.validate(new ImmutableArchivedTask(this));
        }

        private boolean retryCountIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("subtaskConfig");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("exportParams");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("storeParams");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("error");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("attemptId");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("stateParams");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("fullName");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("taskType");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("stateFlags");
            }
            return "Cannot build ArchivedTask, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ArchivedTask {
        @Nullable
        Config subtaskConfig;
        @Nullable
        Config exportParams;
        List<ConfigKey> resetStoreParams = ImmutableList.of();
        @Nullable
        Config storeParams;
        Optional<TaskReport> report = Optional.absent();
        @Nullable
        Config error;
        Optional<Long> resumingTaskId = Optional.absent();
        long id;
        boolean idIsSet;
        long attemptId;
        boolean attemptIdIsSet;
        List<Long> upstreams = ImmutableList.of();
        @Nullable
        Instant updatedAt;
        Optional<Instant> retryAt = Optional.absent();
        Optional<Instant> startedAt = Optional.absent();
        @Nullable
        Config stateParams;
        int retryCount;
        boolean retryCountIsSet;
        Optional<Long> parentId = Optional.absent();
        @Nullable
        String fullName;
        @Nullable
        TaskConfig config;
        @Nullable
        TaskType taskType;
        @Nullable
        TaskStateCode state;
        @Nullable
        TaskStateFlags stateFlags;

        Json() {
        }

        @JsonProperty(value="subtaskConfig")
        public void setSubtaskConfig(Config subtaskConfig) {
            this.subtaskConfig = subtaskConfig;
        }

        @JsonProperty(value="exportParams")
        public void setExportParams(Config exportParams) {
            this.exportParams = exportParams;
        }

        @JsonProperty(value="resetStoreParams")
        public void setResetStoreParams(List<ConfigKey> resetStoreParams) {
            this.resetStoreParams = resetStoreParams;
        }

        @JsonProperty(value="storeParams")
        public void setStoreParams(Config storeParams) {
            this.storeParams = storeParams;
        }

        @JsonProperty(value="report")
        public void setReport(Optional<TaskReport> report) {
            this.report = report;
        }

        @JsonProperty(value="error")
        public void setError(Config error) {
            this.error = error;
        }

        @JsonProperty(value="resumingTaskId")
        public void setResumingTaskId(Optional<Long> resumingTaskId) {
            this.resumingTaskId = resumingTaskId;
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="attemptId")
        public void setAttemptId(long attemptId) {
            this.attemptId = attemptId;
            this.attemptIdIsSet = true;
        }

        @JsonProperty(value="upstreams")
        public void setUpstreams(List<Long> upstreams) {
            this.upstreams = upstreams;
        }

        @JsonProperty(value="updatedAt")
        public void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="retryAt")
        public void setRetryAt(Optional<Instant> retryAt) {
            this.retryAt = retryAt;
        }

        @JsonProperty(value="startedAt")
        public void setStartedAt(Optional<Instant> startedAt) {
            this.startedAt = startedAt;
        }

        @JsonProperty(value="stateParams")
        public void setStateParams(Config stateParams) {
            this.stateParams = stateParams;
        }

        @JsonProperty(value="retryCount")
        public void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
            this.retryCountIsSet = true;
        }

        @JsonProperty(value="parentId")
        public void setParentId(Optional<Long> parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="fullName")
        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        @JsonProperty(value="config")
        public void setConfig(TaskConfig config) {
            this.config = config;
        }

        @JsonProperty(value="taskType")
        public void setTaskType(TaskType taskType) {
            this.taskType = taskType;
        }

        @JsonProperty(value="state")
        public void setState(TaskStateCode state) {
            this.state = state;
        }

        @JsonProperty(value="stateFlags")
        public void setStateFlags(TaskStateFlags stateFlags) {
            this.stateFlags = stateFlags;
        }

        @Override
        public Config getSubtaskConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getExportParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ConfigKey> getResetStoreParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getStoreParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TaskReport> getReport() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getResumingTaskId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getAttemptId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Long> getUpstreams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getRetryAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getStartedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getStateParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRetryCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getParentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFullName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskConfig getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskType getTaskType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskStateCode getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskStateFlags getStateFlags() {
            throw new UnsupportedOperationException();
        }
    }
}

