/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import io.digdag.client.config.Config;
import io.digdag.core.repository.ImmutableWorkflowDefinitionList;
import io.digdag.core.repository.WorkflowDefinition;
import java.time.ZoneId;
import java.util.LinkedHashMap;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
public abstract class WorkflowDefinitionList {
    public abstract List<WorkflowDefinition> get();

    public static WorkflowDefinitionList of(List<WorkflowDefinition> list) {
        return ImmutableWorkflowDefinitionList.builder().addAllGet(list).build();
    }

    @JsonCreator
    public static WorkflowDefinitionList of(Config object) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String key : object.getKeys()) {
            Config copy = object.getNestedOrderedOrGetEmpty(key).deepCopy();
            ZoneId timeZone = (ZoneId)copy.get("timezone", ZoneId.class);
            copy.remove("timezone");
            builder.add((Object)WorkflowDefinition.of(key, copy, timeZone));
        }
        return WorkflowDefinitionList.of((List<WorkflowDefinition>)builder.build());
    }

    @JsonValue
    public LinkedHashMap<String, Config> toJson() {
        LinkedHashMap<String, Config> map = new LinkedHashMap<String, Config>();
        for (WorkflowDefinition wf : this.get()) {
            Config copy = wf.getConfig().deepCopy();
            copy.set("timezone", (Object)wf.getTimeZone());
            map.put(wf.getName(), copy);
        }
        return map;
    }
}

