/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.google.common.collect.ImmutableMap;
import io.digdag.core.repository.ResourceNotFoundException;
import java.time.ZoneId;
import java.util.Map;

public class TimeZoneMap {
    private final Map<Long, ZoneId> map;

    public static TimeZoneMap empty() {
        return new TimeZoneMap((Map<Long, ZoneId>)ImmutableMap.of());
    }

    public TimeZoneMap(Map<Long, ZoneId> map) {
        this.map = map;
    }

    public Map<Long, ZoneId> toMap() {
        return ImmutableMap.copyOf(this.map);
    }

    public ZoneId get(long id) throws ResourceNotFoundException {
        ZoneId proj = this.map.get(id);
        if (proj == null) {
            throw new ResourceNotFoundException("timezone of workflow definition id=" + id);
        }
        return proj;
    }
}

