/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import io.digdag.core.repository.ArchiveType;
import io.digdag.core.repository.ImmutableStoredProjectWithRevision;
import io.digdag.core.repository.Project;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.repository.StoredRevision;
import java.time.Instant;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableStoredProjectWithRevision.class)
@JsonDeserialize(as=ImmutableStoredProjectWithRevision.class)
@Value.Immutable
public abstract class StoredProjectWithRevision
extends Project {
    public abstract int getId();

    public abstract int getSiteId();

    public abstract Instant getCreatedAt();

    public abstract Optional<Instant> getDeletedAt();

    public abstract String getRevisionName();

    public abstract Instant getRevisionCreatedAt();

    public abstract ArchiveType getRevisionArchiveType();

    public abstract Optional<byte[]> getRevisionArchiveMd5();

    public static StoredProjectWithRevision of(StoredProject proj, StoredRevision rev) {
        return ImmutableStoredProjectWithRevision.builder().from(proj).id(proj.getId()).siteId(proj.getSiteId()).createdAt(proj.getCreatedAt()).deletedAt(proj.getDeletedAt()).revisionName(rev.getName()).revisionCreatedAt(rev.getCreatedAt()).revisionArchiveType(rev.getArchiveType()).revisionArchiveMd5(rev.getArchiveMd5()).build();
    }
}

