/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.queue;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.queue.QueueSetting;
import io.digdag.core.queue.QueueSettingImpl;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableQueueSetting
extends QueueSettingImpl {
    private final String name;
    private final Config config;

    private ImmutableQueueSetting(String name, Config config) {
        this.name = name;
        this.config = config;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="config")
    public Config getConfig() {
        return this.config;
    }

    public final ImmutableQueueSetting withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableQueueSetting(newValue, this.config);
    }

    public final ImmutableQueueSetting withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"config");
        return new ImmutableQueueSetting(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueueSetting && this.equalTo((ImmutableQueueSetting)another);
    }

    private boolean equalTo(ImmutableQueueSetting another) {
        return this.name.equals(another.name) && this.config.equals((Object)another.config);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.config.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QueueSetting").omitNullValues().add("name", (Object)this.name).add("config", (Object)this.config).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableQueueSetting fromJson(Json json) {
        Builder builder = ImmutableQueueSetting.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        return builder.build();
    }

    public static ImmutableQueueSetting copyOf(QueueSettingImpl instance) {
        if (instance instanceof ImmutableQueueSetting) {
            return (ImmutableQueueSetting)instance;
        }
        return ImmutableQueueSetting.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_CONFIG = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private Config config;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(QueueSetting instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(QueueSettingImpl instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof QueueSetting) {
                QueueSetting instance = (QueueSetting)object;
                this.name(instance.getName());
                this.config(instance.getConfig());
            }
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final Builder config(Config config) {
            this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableQueueSetting build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueueSetting(this.name, this.config);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("config");
            }
            return "Cannot build QueueSetting, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends QueueSettingImpl {
        @Nullable
        String name;
        @Nullable
        Config config;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }
    }
}

