/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.plugin;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import io.digdag.client.config.Config;
import io.digdag.core.plugin.NullPluginLoader;
import io.digdag.core.plugin.PluginLoader;
import io.digdag.core.plugin.RemotePluginLoader;
import java.nio.file.Paths;

public class DynamicPluginModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(PluginLoader.class).toProvider(PluginLoaderProvider.class).in(Scopes.SINGLETON);
    }

    public static class PluginLoaderProvider
    implements Provider<PluginLoader> {
        private final PluginLoader pluginLoader;

        @Inject
        public PluginLoaderProvider(Config systemConfig) {
            boolean enabled = (Boolean)systemConfig.get("plugin.enabled", Boolean.TYPE, (Object)true);
            if (enabled) {
                String localRepositoryPath = (String)systemConfig.get("plugin.local-path", String.class, (Object)".digdag/plugins");
                this.pluginLoader = new RemotePluginLoader(Paths.get(localRepositoryPath, new String[0]));
            } else {
                this.pluginLoader = new NullPluginLoader();
            }
        }

        public PluginLoader get() {
            return this.pluginLoader;
        }
    }
}

